package com.xforceplus.xlog.springboot.autoconfiguration.jooq;

import com.xforceplus.xlog.core.model.setting.XlogSettings;
import com.xforceplus.xlog.jooq.model.XlogJooqExecutionListener;
import com.xforceplus.xlog.jooq.model.XlogJooqExecutionListenerProvider;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name = {"org.jooq.DSLContext"})
@AutoConfigureAfter(XlogAutoConfiguration.class)
@ConditionalOnProperty(prefix = "xlog", name = {"enabled", "jooq.enabled"}, havingValue = "true")
public class XlogJooqConfiguration {
    private final XlogProperties xlogProperties;

    public XlogJooqConfiguration(final XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean
    public XlogJooqExecutionListenerProvider xlogJooqExecutionListenerProvider(
        final LogSender logSender,
        final @Autowired(required = false) XlogSettings xlogSettings
    ) {
        final XlogJooqExecutionListener listener = new XlogJooqExecutionListener(xlogProperties.getStoreName(), logSender, xlogSettings);
        return new XlogJooqExecutionListenerProvider(listener);
    }
}
