package com.xforceplus.xlog.springboot.autoconfiguration.messagebus;

import com.xforceplus.phoenix.messagebus.model.MessageBusConsumerInterceptor;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.messagebus.model.impl.MessageBusConsumerInterceptorImpl;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 消息总线消费者配置器
 *
 * @author gulei
 * @date 2023/01/19
 */
@Configuration
@ConditionalOnClass(MessageBusConsumerInterceptor.class)
@AutoConfigureAfter(XlogAutoConfiguration.class)
@ConditionalOnProperty(prefix = "xlog", name = {"enabled", "message-bus.consumer.enabled"}, havingValue = "true")
public class XlogMessageBusConsumerConfiguration {
    private final XlogProperties xlogProperties;

    /**
     * 构造函数
     *
     * @param xlogProperties xlog配置
     */
    public XlogMessageBusConsumerConfiguration(final XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    /**
     * 注入消息总线消费者拦截器实例
     *
     * @param logSender 日志发送器
     * @return 消息总线消费者拦截器实例
     */
    @Bean
    @ConditionalOnMissingBean
    public MessageBusConsumerInterceptor messageBusConsumerInterceptor(final LogSender logSender) {
        return new MessageBusConsumerInterceptorImpl(logSender, this.xlogProperties.getStoreName());
    }
}
