package com.xforceplus.xlog.springboot.autoconfiguration.rocketmq;

import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.setting.XlogRocketMqConsumerSettings;
import com.xforceplus.xlog.core.model.setting.XlogRocketMqSettings;
import com.xforceplus.xlog.core.model.setting.XlogSettings;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.rocketmq.model.XlogRocketMqConsumerListenerImpl;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.lang.reflect.Field;
import java.util.Optional;

@Slf4j
@Configuration
@ConditionalOnClass(name = {"org.apache.rocketmq.spring.support.DefaultRocketMQListenerContainer", "com.xfrcpls.xcomponent.xrmq.domain.model.BaseRmqMessage"})
@AutoConfigureAfter(XlogAutoConfiguration.class)
@ConditionalOnProperty(prefix = "xlog", name = {"enabled", "rocket-mq.consumer.enabled"}, havingValue = "true")
public class XlogRocketMqConsumerConfiguration {
    private final XlogProperties xlogProperties;

    @Autowired
    public XlogRocketMqConsumerConfiguration(final XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean("xlogRocketMqConsumerListener")
    @ConditionalOnMissingBean(name = "xlogRocketMqConsumerListener")
    @SneakyThrows
    public MethodEventListener xlogRocketMqConsumerListener(
        final LogSender logSender,
        final @Autowired(required = false) XlogSettings xlogSettings
    ) {
        final XlogRocketMqConsumerSettings xlogRocketMqConsumerSettings = Optional.ofNullable(xlogSettings).map(XlogSettings::getRocketMq)
            .map(XlogRocketMqSettings::getConsumer)
            .orElse(null);

        final MethodEventListener listener = new XlogRocketMqConsumerListenerImpl(logSender, this.xlogProperties.getStoreName(), xlogRocketMqConsumerSettings);
        final Class<?> targetClazz = Class.forName("org.apache.rocketmq.spring.support.DefaultRocketMQListenerContainer$DefaultMessageListenerConcurrently");
        final Field listenerField = targetClazz.getDeclaredField("_listener");
        listenerField.set(targetClazz, listener);
        log.info("xlog.rocketmq.consumer已启动...");
        return listener;
    }
}
