package com.xforceplus.xlog.springboot.autoconfiguration.schedule;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.schedule.model.XlogScheduleInterceptor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Schedule配置器
 *
 * @author gulei
 * @date 2024/02/09
 */
@Slf4j
@Configuration
@AutoConfigureAfter(XlogAutoConfiguration.class)
@ConditionalOnProperty(prefix = "xlog", name = {"enabled", "schedule.spring-boot-schedule.enabled"}, havingValue = "true")
public class XlogScheduleConfiguration {
    private final XlogProperties xlogProperties;

    /**
     * 构造函数
     *
     * @param xlogProperties xlog配置
     */
    @Autowired
    public XlogScheduleConfiguration(final XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    /**
     * 注入Schedule拦截器实例
     *
     * @param logSender 日志发送器
     * @return Schedule拦截器实例
     */
    @Bean
    @ConditionalOnMissingBean
    public XlogScheduleAdvice getXlogScheduleAdvice(final LogSender logSender) {
        final XlogScheduleAdvice xlogScheduleAdvice = new XlogScheduleAdvice(new XlogScheduleInterceptor(logSender, this.xlogProperties.getStoreName()));
        log.info(String.format("xlog.schedule.spring-boot-schedule已启动... 参数: %s", JSON.toJSONString(this.xlogProperties.getSchedule().getSpringBootSchedule())));
        return xlogScheduleAdvice;
    }
}
