package com.xforceplus.xlog.springboot.autoconfiguration.setting;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.model.setting.XlogSettings;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogSettingProperties;
import com.xforceplus.xlog.springboot.setting.model.XlogSettingWorker;
import com.xforceplus.xlog.springboot.setting.model.impl.XlogApolloSettingWorkerImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * XlogSettingConfiguration
 *
 * @author gulei
 * @date 2024/02/10
 */
@Slf4j
@Configuration
@AutoConfigureAfter(XlogAutoConfiguration.class)
@ConditionalOnProperty(prefix = "xlog", name = {"enabled", "setting.enabled"}, havingValue = "true")
public class XlogApolloSettingConfiguration {
    private final XlogProperties xlogProperties;

    @Autowired
    public XlogApolloSettingConfiguration(final XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public XlogSettings getXlogSettings() {
        return new XlogSettings();
    }

    @Bean
    @ConditionalOnMissingBean(XlogSettingWorker.class)
    @ConditionalOnClass(name = "com.ctrip.framework.apollo.ConfigService")
    @ConditionalOnProperty(prefix = "xlog.setting", name = "namespaceName")
    public XlogSettingWorker getXlogApolloSettingWorker(XlogSettings xlogSettings) {
        final XlogSettingProperties settingProperties = this.xlogProperties.getSetting();
        final XlogSettingWorker worker = new XlogApolloSettingWorkerImpl(this.xlogProperties.getSetting(), xlogSettings);

        try {
            worker.init();
            log.info(String.format("xlog.setting[Apollo]已启动... 参数: %s", JSON.toJSONString(settingProperties)));
        } catch (Exception ex) {
            log.warn("XlogSetting[Apollo]数据初始化加载时异常!", ex);
        }

        return worker;
    }
}
