package com.xforceplus.xlog.springboot.autoconfiguration.sqs;

import com.xforceplus.xlog.core.model.setting.XlogSettings;
import com.xforceplus.xlog.core.model.setting.XlogSqsSettings;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xplat.aws.sqs.listener.AbsSQSListener;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Optional;

@Slf4j
@Configuration
@ConditionalOnClass({AbsSQSListener.class})
@AutoConfigureAfter(XlogAutoConfiguration.class)
@ConditionalOnProperty(prefix = "xlog", name = {"enabled", "sqs.consumer.enabled"}, havingValue = "true")
public class XlogSqsConsumerConfiguration {
    private final XlogProperties xlogProperties;

    @Autowired
    public XlogSqsConsumerConfiguration(final XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public XlogSqsConsumerBeanPostProcessor xlogSqsConsumerBeanPostProcessor() {
        return new XlogSqsConsumerBeanPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public XlogSqsConsumerAdvice xlogSqsConsumerAdvice(
            final LogSender logSender,
            final @Autowired(required = false) XlogSettings xlogSettings
    ) {
        final XlogSqsSettings xlogSqsSettings = Optional.ofNullable(xlogSettings).map(XlogSettings::getSqs).orElse(null);
        return new XlogSqsConsumerAdvice(logSender, xlogProperties, xlogSqsSettings);
    }
}
