package com.xforceplus.xlog.springboot.autoconfiguration.standalone;

import com.xforceplus.apollo.janus.standalone.sdk.annotation.GlobalEventListener;
import com.xforceplus.apollo.janus.standalone.sdk.annotation.GlobalMessageEventListener;
import com.xforceplus.apollo.janus.standalone.sdk.message.AbsGlobalMessageEventWithResultListener;
import com.xforceplus.apollo.janus.standalone.sdk.message.IGlobalMessageEventListener;
import com.xforceplus.xlog.core.utils.ReflectionUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ClassUtils;

import static org.springframework.core.annotation.AnnotationUtils.findAnnotation;

@Slf4j
public class XlogStandaloneConsumerBeanPostProcessor implements BeanPostProcessor {
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {

        // @IGlobalMessageEventListener + IGlobalMessageEventListener 组合
        // 使 GlobalMessageEventListener 注解能够被aop创建的代理实例继承，因为公司框架依赖这个识别哪些bean是监听者
        if (ClassUtils.isPresent("com.xforceplus.apollo.janus.standalone.sdk.message.IGlobalMessageEventListener", null)
                && ClassUtils.isPresent("com.xforceplus.apollo.janus.standalone.sdk.annotation.GlobalMessageEventListener", null)) {
            if (bean instanceof IGlobalMessageEventListener && findAnnotation(bean.getClass(), GlobalMessageEventListener.class) != null) {
                ReflectionUtil.makeAnnotationInherited(bean.getClass().getAnnotation(GlobalMessageEventListener.class));
                return bean;
            }
        }

        // @GlobalEventListener + IGlobalMessageEventListener 组合
        // 使 GlobalEventListener 注解能够被aop创建的代理实例继承，因为公司框架依赖这个识别哪些bean是监听者
        if (ClassUtils.isPresent("com.xforceplus.apollo.janus.standalone.sdk.message.IGlobalMessageEventListener", null)
                && ClassUtils.isPresent("com.xforceplus.apollo.janus.standalone.sdk.annotation.GlobalEventListener", null)) {
            if (bean instanceof IGlobalMessageEventListener && findAnnotation(bean.getClass(), GlobalEventListener.class) != null) {
                ReflectionUtil.makeAnnotationInherited(bean.getClass().getAnnotation(GlobalEventListener.class));
                return bean;
            }
        }

        // @GlobalEventListener + AbsGlobalMessageEventWithResultListener 组合
        // 使 GlobalEventListener 注解能够被aop创建的代理实例继承，因为公司框架依赖这个识别哪些bean是监听者
        if (ClassUtils.isPresent("com.xforceplus.apollo.janus.standalone.sdk.message.AbsGlobalMessageEventWithResultListener", null)
                && ClassUtils.isPresent("com.xforceplus.apollo.janus.standalone.sdk.annotation.GlobalEventListener", null)) {
            if (bean instanceof AbsGlobalMessageEventWithResultListener && findAnnotation(bean.getClass(), GlobalEventListener.class) != null) {
                ReflectionUtil.makeAnnotationInherited(bean.getClass().getAnnotation(GlobalEventListener.class));
                return bean;
            }
        }

        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object o, String s) throws BeansException {
        return o;
    }
}

