package com.xforceplus.xlog.springboot.autoconfiguration.standalone;

import com.xforceplus.apollo.janus.standalone.sdk.annotation.GlobalMessageEventListener;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.standalone.model.StandaloneConsumerInterceptor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Slf4j
@Configuration
@AutoConfigureAfter(XlogAutoConfiguration.class)
@ConditionalOnClass({GlobalMessageEventListener.class})
@ConditionalOnProperty(prefix = "xlog", name = {"enabled", "standalone.consumer.enabled"}, havingValue = "true")
public class XlogStandaloneConsumerConfiguration {
    private final XlogProperties xlogProperties;

    public XlogStandaloneConsumerConfiguration(final XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public XlogStandaloneConsumerAdvice xlogStandaloneConsumerAdvice(final LogSender logSender) {
        log.info(String.format("xlog.standalone.consumer已尝试启动... 参数: %s", this.xlogProperties.getStandalone()));
        return new XlogStandaloneConsumerAdvice(new StandaloneConsumerInterceptor(logSender, this.xlogProperties.getStoreName()));
    }

    @Bean
    @ConditionalOnMissingBean
    public XlogStandaloneConsumerBeanPostProcessor xlogStandaloneConsumerBeanPostProcessor() {
        return new XlogStandaloneConsumerBeanPostProcessor();
    }
}
