package com.xforceplus.xlog.springboot.autoconfiguration.xplatcommonconfig;

import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

/**
 * XlogGlobalExceptionConfiguration
 *
 * @author gulei
 * @date 2023/1/21
 */
@Order(Ordered.HIGHEST_PRECEDENCE + 100)
@AutoConfigureAfter(XlogAutoConfiguration.class)
@ConditionalOnClass(name = "com.xforceplus.common.config.exception.GlobalExceptionAdvice")
@Configuration
public class XlogGlobalExceptionConfiguration {

    public XlogGlobalExceptionConfiguration() {

    }

    @Bean
    @ConditionalOnMissingBean
    public XlogGlobalExceptionAdvice xlogGlobalExceptionAdvice() {
        return new XlogGlobalExceptionAdvice();
    }
}
