package com.xforceplus.xlog.springboot.method.model;

import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.impl.MethodLogEvent;
import com.xforceplus.xlog.core.utils.Callable;
import com.xforceplus.xlog.logsender.model.LogSender;

/**
 * XlogMethodInterceptor
 *
 * @author gulei
 * @date 2024/03/18
 */
public class XlogMethodInterceptor {
    private final LogSender logSender;
    private final String storeName;

    public XlogMethodInterceptor(final LogSender logSender, final String storeName) {
        this.logSender = logSender;
        this.storeName = storeName;
    }

    public Object intercept(String className, String methodName, String injectType, Object[] args, Callable callable) throws Throwable {
        final MethodLogEvent event = new MethodLogEvent();

        event.setClassName(className);
        event.setInjectType(injectType);
        event.setStoreName(storeName);
        event.setName(methodName);
        event.setTraceId(LogContext.getTraceId());

        try {
            return callable.call();
        } catch (Throwable throwable) {
            event.setThrowable(throwable);
            throw throwable;
        } finally {
            event.fetchContext();

            logSender.send(event);
        }
    }
}
