package com.xforceplus.xlog.springboot.webmvc.model;

import io.swagger.annotations.ApiOperation;

import javax.annotation.Nullable;
import java.lang.reflect.Method;

public class SwaggerUtil {

    /**
     * 获取方法(包括接口中)的指定注解
     *
     * @param method 目标方法
     * @return 目标注解
     */
    @Nullable
    public ApiOperation getApiOperation(final Method method) {
        final ApiOperation localAnnotation = method.getAnnotation(ApiOperation.class);

        if (localAnnotation != null) {
            return localAnnotation;
        }

        final Class<?>[] interfaces = method.getDeclaringClass().getInterfaces();

        for (Class<?> anInterface : interfaces) {
            try {
                final Method interfaceMethod = anInterface.getMethod(method.getName(), method.getParameterTypes());
                final ApiOperation interfaceAnnotation = interfaceMethod.getAnnotation(ApiOperation.class);
                if (interfaceAnnotation != null) {
                    return interfaceAnnotation;
                }
            } catch (NoSuchMethodException ex) {
                continue;
            }
        }

        return null;
    }
}
