package com.xforceplus.xlog.springboot.xlogversion;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.logsender.model.VersionLogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import org.springframework.boot.SpringApplication;
import org.springframework.scheduling.annotation.Scheduled;

/**
 * ReportVersionSchedule
 *
 * @author gulei
 * @date 2024/03/18
 */
public class XlogVersionSchedule {
    private final VersionLogSender versionLogSender;
    private final XlogProperties xlogProperties;

    public XlogVersionSchedule(final VersionLogSender versionLogSender, final XlogProperties xlogProperties) {
        this.versionLogSender = versionLogSender;
        this.xlogProperties = xlogProperties;
    }

    @Scheduled(cron = "0 0 * * * ?")
    public void reportVersion() {
        final String springbootVersion = SpringApplication.class.getPackage().getImplementationVersion();
        versionLogSender.send("Heartbeat", JSON.toJSONString(xlogProperties), springbootVersion);
    }
}
