package com.xforceplus.xlog.springboot.autoconfiguration.apacheclient;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.apache.httpclient.model.impl.XlogApacheClientListener;
import com.xforceplus.xlog.core.constant.RpcUserAgent;
import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.setting.XlogRpcSettings;
import com.xforceplus.xlog.core.model.setting.XlogSettings;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.okhttp.model.impl.XlogOkHttpRealCallListener;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.lang.reflect.Field;
import java.util.Optional;

/**
 * Apache Http Client 监听器配置
 *
 * @author gulei
 * @date 2024/08/16
 */
@Slf4j
@Configuration
@AutoConfigureAfter(XlogAutoConfiguration.class)
@ConditionalOnClass(value = {CloseableHttpClient.class})
@ConditionalOnProperty(prefix = "xlog", name = {"enabled", "rpc.apache-client.enabled"}, havingValue = "true")
public class XlogApacheClientConfiguration {
    private final XlogProperties xlogProperties;

    /**
     * 构造函数
     *
     * @param xlogProperties xlog配置
     */
    public XlogApacheClientConfiguration(final XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    /**
     * 注入OkHttp3 RealCall监听器
     *
     * @param logSender 日志发送者
     * @return 监听器实例
     */
    @Bean("xlogApacheClientListener")
    @ConditionalOnMissingBean(name = "xlogApacheClientListener")
    @SneakyThrows
    public MethodEventListener xlogApacheClientListener(
            final LogSender logSender,
            final @Autowired(required = false) XlogSettings xlogSettings
    ) {
        final XlogRpcSettings xlogRpcSettings = Optional.ofNullable(xlogSettings).map(XlogSettings::getRpc).orElse(null);
        final MethodEventListener listener = new XlogApacheClientListener(logSender, this.xlogProperties.getStoreName(), xlogRpcSettings);
        final Field listenerField = CloseableHttpClient.class.getDeclaredField("_listener");
        listenerField.setAccessible(true);
        listenerField.set(CloseableHttpClient.class, listener);
        log.info(String.format("xlog.ApacheClient已启动... 参数: %s", JSON.toJSONString(xlogRpcSettings)));
        return listener;
    }
}
