package com.xforceplus.xlog.springboot.autoconfiguration.schedule;

import com.xforceplus.xlog.springboot.schedule.model.XlogScheduleInterceptor;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * XlogScheduleAdvice
 *
 * @author gulei
 * @date 2024/02/08
 */
@Aspect
public class XlogScheduleAdvice {
    private final XlogScheduleInterceptor xlogScheduleInterceptor;

    /**
     * 构造函数
     *
     * @param xlogScheduleInterceptor Schedule拦截器
     */
    @Autowired
    public XlogScheduleAdvice(final XlogScheduleInterceptor xlogScheduleInterceptor) {
        this.xlogScheduleInterceptor = xlogScheduleInterceptor;
    }

    /**
     * 切入点
     *
     * @param proceedingJoinPoint 处理点
     * @return 处理结果
     * @throws Throwable 异常
     */
    @Around("@annotation(org.springframework.scheduling.annotation.Scheduled)")
    public Object cut(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        final Signature signature = ((MethodInvocationProceedingJoinPoint) proceedingJoinPoint).getSignature();
        final String name = signature.getDeclaringTypeName() + "." + signature.getName();
        return this.xlogScheduleInterceptor.intercept(name, proceedingJoinPoint::proceed);
    }
}
