package com.xforceplus.xlog.springboot.autoconfiguration.sqs;

import com.xforceplus.xlog.core.utils.ReflectionUtil;
import com.xforceplus.xplat.aws.spring.annotation.SQSListener;
import com.xforceplus.xplat.aws.sqs.listener.AbsSQSListener;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class XlogSqsConsumerBeanPostProcessor implements BeanPostProcessor {
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!(bean instanceof AbsSQSListener)) {
            return bean;
        }

        // 使 SQSListener 注解能够被aop创建的代理实例继承，因为公司sqs框架依赖这个识别哪些bean是监听者
        final SQSListener sqsAnnotation = bean.getClass().getAnnotation(SQSListener.class);
        if (sqsAnnotation != null) {
            ReflectionUtil.makeAnnotationInherited(sqsAnnotation);
        }

        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object o, String s) throws BeansException {
        return o;
    }
}

