package com.xforceplus.xlog.springboot.autoconfiguration.xxljob;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.setting.XlogSettings;
import com.xforceplus.xlog.core.model.setting.XlogXxlJobSettings;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.xxljob.model.impl.XlogMethodJobHandlerListenerImpl;
import com.xxl.job.core.handler.impl.MethodJobHandler;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.lang.reflect.Field;
import java.util.Optional;

/**
 * XlogXxlJobConfiguration
 *
 * @author gulei
 * @date 2023/08/17
 */
@Slf4j
@Configuration
@AutoConfigureAfter(XlogAutoConfiguration.class)
@ConditionalOnClass({MethodJobHandler.class})
@ConditionalOnProperty(prefix = "xlog", name = {"enabled", "schedule.xxl-job.enabled"}, havingValue = "true")
public class XlogXxlJobConfiguration {
    private final XlogProperties xlogProperties;
    private final XlogXxlJobSettings xxlJobSettings;

    public XlogXxlJobConfiguration(
            final XlogProperties xlogProperties,
            final @Autowired(required = false) XlogSettings xlogSettings
    ) {
        this.xlogProperties = xlogProperties;
        this.xxlJobSettings = Optional.ofNullable(xlogSettings).map(XlogSettings::getXxlJob).orElse(null);
    }

    /**
     * 注入XxlJob MethodJobHandler监听器
     *
     * @param logSender 日志发送者
     * @return 监听器实例
     */
    @Bean("xlogMethodJobHandlerListener")
    @ConditionalOnMissingBean(name = "xlogMethodJobHandlerListener")
    @SneakyThrows
    public MethodEventListener xlogMethodJobHandlerListener(final LogSender logSender) {
        final MethodEventListener listener = new XlogMethodJobHandlerListenerImpl(logSender, this.xlogProperties.getStoreName(), xxlJobSettings);
        final Field listenerField = MethodJobHandler.class.getDeclaredField("_listener");
        listenerField.set(MethodJobHandler.class, listener);
        log.info(String.format("xlog.schedule.xxl-job... 静态参数: %s, 动态参数: %s", JSON.toJSONString(this.xlogProperties.getSchedule().getXxlJob()), JSON.toJSONString(xxlJobSettings)));
        return listener;
    }
}
