/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.xforceplus.xlog.core.utils.JavassistUtil;
import com.xforceplus.xlog.messagebus.MessageBusPreparing;
import com.xforceplus.xlog.okhttp.XlogOkHttpPreparing;
import com.xforceplus.xlog.springboot.rabbitmq.XlogRabbitMqPreparing;
import com.xforceplus.xlog.sqs.SqsPreparing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;

public class XlogApplicationPreparedListener
implements ApplicationListener<ApplicationPreparedEvent> {
    private static final Logger log = LoggerFactory.getLogger(XlogApplicationPreparedListener.class);
    private boolean done;

    public void onApplicationEvent(ApplicationPreparedEvent applicationPreparedEvent) {
        EnvironmentProperties environmentProperties = this.createEnvironmentProperties(applicationPreparedEvent);
        if (this.done) {
            return;
        }
        this.done = true;
        if (!environmentProperties.isTrue("xlog.enabled")) {
            return;
        }
        if (environmentProperties.isTrue("xlog.sqs.producer.enabled")) {
            SqsPreparing.prepare();
        }
        if (environmentProperties.isTrue("xlog.message-bus.producer.enabled")) {
            MessageBusPreparing.prepare();
        }
        if (environmentProperties.isTrue("xlog.rabbit-mq.producer.enabled")) {
            XlogRabbitMqPreparing.prepareProducer();
        }
        if (environmentProperties.isTrue("xlog.rabbit-mq.consumer.enabled")) {
            XlogRabbitMqPreparing.prepareConsumer();
        }
        if (environmentProperties.isTrue("xlog.rpc.ok-http.enabled")) {
            XlogOkHttpPreparing.prepare();
        }
    }

    private EnvironmentProperties createEnvironmentProperties(ApplicationPreparedEvent applicationStartingEvent) {
        String configServiceClassName = "com.ctrip.framework.apollo.ConfigService";
        if (JavassistUtil.checkClassIfExist((String)"com.ctrip.framework.apollo.ConfigService")) {
            return new EnvironmentPropertiesApolloImpl((Environment)applicationStartingEvent.getApplicationContext().getEnvironment());
        }
        return new EnvironmentPropertiesImpl((Environment)applicationStartingEvent.getApplicationContext().getEnvironment());
    }

    private static class EnvironmentPropertiesApolloImpl
    implements EnvironmentProperties {
        private final Environment environment;
        private final Config appConfig;

        public EnvironmentPropertiesApolloImpl(Environment environment) {
            this.environment = environment;
            this.appConfig = ConfigService.getAppConfig();
        }

        @Override
        public boolean isTrue(String propertyPath) {
            return this.environment != null && "true".equals(this.environment.getProperty(propertyPath)) || this.appConfig != null && this.appConfig.getBooleanProperty(propertyPath, Boolean.valueOf(false)) != false;
        }
    }

    private static class EnvironmentPropertiesImpl
    implements EnvironmentProperties {
        private final Environment environment;

        public EnvironmentPropertiesImpl(Environment environment) {
            this.environment = environment;
        }

        @Override
        public boolean isTrue(String propertyPath) {
            return this.environment != null && "true".equals(this.environment.getProperty(propertyPath));
        }
    }

    private static interface EnvironmentProperties {
        public boolean isTrue(String var1);
    }
}

