/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration.messagebus;

import com.xforceplus.janus.message.sdk.MBClient;
import com.xforceplus.xlog.core.model.MethodListener;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.messagebus.model.impl.MessageBusProducerListenerImpl;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import java.lang.reflect.Field;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MBClient.class})
@AutoConfigureAfter(value={XlogAutoConfiguration.class})
@ConditionalOnProperty(prefix="xlog", name={"enabled", "message-bus.producer.enabled"}, havingValue="true")
public class XlogMessageBusProducerConfiguration {
    private final XlogProperties xlogProperties;

    public XlogMessageBusProducerConfiguration(XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean(value={"messageBusProducerListener"})
    @ConditionalOnMissingBean
    public MethodListener xlogMessageBusProducerListener(LogSender logSender) {
        MessageBusProducerListenerImpl listener = new MessageBusProducerListenerImpl(logSender, this.xlogProperties.getStoreName());
        Field listenerField = MBClient.class.getDeclaredField("_listener");
        listenerField.set(MBClient.class, listener);
        return listener;
    }
}

