/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration.okhttp;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.model.MethodListener;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.okhttp.model.impl.XlogOkHttp4RealCallListenerImpl;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import java.lang.reflect.Field;
import okhttp3.internal.connection.RealCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={XlogAutoConfiguration.class})
@ConditionalOnClass(value={RealCall.class})
@ConditionalOnProperty(prefix="xlog", name={"enabled", "rpc.ok-http.enabled"}, havingValue="true")
public class XlogOkHttp4RealCallConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XlogOkHttp4RealCallConfiguration.class);
    private final XlogProperties xlogProperties;

    public XlogOkHttp4RealCallConfiguration(XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean(value={"xlogOkHttp4RealCallListener"})
    @ConditionalOnMissingBean(name={"xlogOkHttp4RealCallListener"})
    public MethodListener xlogOkHttp4RealCallListener(LogSender logSender) {
        XlogOkHttp4RealCallListenerImpl listener = new XlogOkHttp4RealCallListenerImpl(logSender, this.xlogProperties.getStoreName());
        Field listenerField = RealCall.class.getDeclaredField("_listener");
        listenerField.set(RealCall.class, listener);
        log.info(String.format("xlog.okhttp(4)... \u53c2\u6570: %s", JSON.toJSONString((Object)this.xlogProperties.getRpc().getOkHttp())));
        return listener;
    }
}

