/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.model.MethodListener;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.rabbitmq.model.XlogRabbitMqConsumerListenerImpl;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={XlogAutoConfiguration.class})
@ConditionalOnClass(value={MessagingMessageListenerAdapter.class})
@ConditionalOnProperty(prefix="xlog", name={"enabled", "rabbit-mq.consumer.enabled"}, havingValue="true")
public class XlogRabbitMqConsumerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XlogRabbitMqConsumerConfiguration.class);
    private final XlogProperties xlogProperties;

    @Autowired
    public XlogRabbitMqConsumerConfiguration(XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean(value={"xlogRabbitMqConsumerListener"})
    @ConditionalOnMissingBean(name={"xlogRabbitMqConsumerListener"})
    public MethodListener xlogRabbitMqConsumerListener(LogSender logSender) {
        XlogRabbitMqConsumerListenerImpl listener = new XlogRabbitMqConsumerListenerImpl(logSender, this.xlogProperties.getStoreName());
        Field listenerField = MessagingMessageListenerAdapter.class.getDeclaredField("_listener");
        listenerField.set(MessagingMessageListenerAdapter.class, listener);
        log.info(String.format("xlog.rabbit-mq.consumer\u5df2\u542f\u52a8... \u53c2\u6570: %s", JSON.toJSONString((Object)this.xlogProperties.getRabbitMq().getConsumer())));
        return listener;
    }
}

