/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration.sqs;

import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.autoconfiguration.sqs.XlogSqsConsumerAdvice;
import com.xforceplus.xlog.springboot.autoconfiguration.sqs.XlogSqsConsumerBeanPostProcessor;
import com.xforceplus.xplat.aws.sqs.listener.AbsSQSListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={AbsSQSListener.class})
@AutoConfigureAfter(value={XlogAutoConfiguration.class})
@ConditionalOnProperty(prefix="xlog", name={"enabled", "sqs.consumer.enabled"}, havingValue="true")
public class XlogSqsConsumerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XlogSqsConsumerConfiguration.class);
    private final XlogProperties xlogProperties;

    @Autowired
    public XlogSqsConsumerConfiguration(XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public XlogSqsConsumerBeanPostProcessor xlogSqsConsumerBeanPostProcessor() {
        return new XlogSqsConsumerBeanPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public XlogSqsConsumerAdvice xlogSqsConsumerAdvice(LogSender logSender) {
        return new XlogSqsConsumerAdvice(logSender, this.xlogProperties);
    }
}

