/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration.standalone;

import com.xforceplus.apollo.janus.standalone.sdk.annotation.GlobalMessageEventListener;
import com.xforceplus.xlog.standalone.model.StandaloneConsumerInterceptor;
import com.xforceplus.xlog.standalone.model.StandaloneMessageData;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.annotation.AnnotationUtils;

@Aspect
public class XlogStandaloneConsumerAdvice {
    private final StandaloneConsumerInterceptor interceptor;

    public XlogStandaloneConsumerAdvice(StandaloneConsumerInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    @Around(value="@within(com.xforceplus.apollo.janus.standalone.sdk.annotation.GlobalMessageEventListener)")
    public Object cut(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        String methodName = proceedingJoinPoint.getSignature().getName();
        Object target = proceedingJoinPoint.getTarget();
        if (!"onMessage".equals(methodName) && !"onMessageWithResult".equals(methodName)) {
            return proceedingJoinPoint.proceed();
        }
        Object queueName = AnnotationUtils.getValue((Annotation)target.getClass().getAnnotation(GlobalMessageEventListener.class), (String)"queueName");
        Object[] args = proceedingJoinPoint.getArgs();
        StandaloneMessageData standaloneMessageData = new StandaloneMessageData();
        standaloneMessageData.setQueueName(queueName + "");
        if (args[0] instanceof String) {
            standaloneMessageData.setMessageId((String)args[0]);
        }
        if (args[1] instanceof Map) {
            standaloneMessageData.setHeaders((Map)args[1]);
        }
        if (args[2] instanceof String) {
            standaloneMessageData.setMessageBody((String)args[2]);
        }
        if (args[3] instanceof String) {
            standaloneMessageData.setSource((String)args[3]);
        }
        return this.interceptor.intercept(standaloneMessageData, () -> ((ProceedingJoinPoint)proceedingJoinPoint).proceed());
    }
}

