/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.autoconfiguration.standalone;

import com.xforceplus.apollo.janus.standalone.sdk.annotation.GlobalMessageEventListener;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.autoconfiguration.standalone.XlogStandaloneConsumerAdvice;
import com.xforceplus.xlog.springboot.autoconfiguration.standalone.XlogStandaloneConsumerBeanPostProcessor;
import com.xforceplus.xlog.standalone.model.StandaloneConsumerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={XlogAutoConfiguration.class})
@ConditionalOnClass(value={GlobalMessageEventListener.class})
@ConditionalOnProperty(prefix="xlog", name={"enabled", "standalone.consumer.enabled"}, havingValue="true")
public class XlogStandaloneConsumerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XlogStandaloneConsumerConfiguration.class);
    private final XlogProperties xlogProperties;

    public XlogStandaloneConsumerConfiguration(XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public XlogStandaloneConsumerAdvice xlogStandaloneConsumerAdvice(LogSender logSender) {
        log.info(String.format("xlog.standalone.consumer\u5df2\u5c1d\u8bd5\u542f\u52a8... \u53c2\u6570: %s", this.xlogProperties.getStandalone()));
        return new XlogStandaloneConsumerAdvice(new StandaloneConsumerInterceptor(logSender, this.xlogProperties.getStoreName()));
    }

    @Bean
    @ConditionalOnMissingBean
    public XlogStandaloneConsumerBeanPostProcessor xlogStandaloneConsumerBeanPostProcessor() {
        return new XlogStandaloneConsumerBeanPostProcessor();
    }
}

