/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.feign.model;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.impl.HttpLogEvent;
import com.xforceplus.xlog.core.utils.Callable;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import feign.Request;
import feign.Response;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class XlogFeignInterceptor {
    private final LogSender logSender;
    private final String storeName;

    public XlogFeignInterceptor(LogSender logSender, String storeName) {
        this.logSender = logSender;
        this.storeName = storeName;
    }

    public Response intercept(Request request, Request.Options options, Callable callable) throws Throwable {
        Response response;
        String traceId = LogContext.getTraceId();
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            HashMap headers = Maps.newHashMap((Map)request.headers());
            headers.put("X-Trace-Id", Lists.newArrayList((Object[])new String[]{traceId}));
        }
        HttpLogEvent event = new HttpLogEvent();
        event.setStoreName(this.storeName);
        event.setType("RPC");
        event.setTraceId(traceId);
        event.setParentTraceId(LogContext.getParentTraceId());
        event.setUserAgent("Feign");
        event.setTenantInfo(LogContext.getTenantInfo());
        this.beforeExecute(event, request);
        try {
            Response originalResponse = (Response)callable.call();
            response = originalResponse.toBuilder().body(IOUtils.toByteArray((InputStream)originalResponse.body().asInputStream())).build();
        }
        catch (Throwable throwable) {
            event.setThrowable(throwable);
            this.logSender.send((LogEvent)event);
            throw throwable;
        }
        this.afterExecute(event, response);
        this.logSender.send((LogEvent)event);
        return response;
    }

    private void beforeExecute(HttpLogEvent event, Request request) {
        try {
            String url = request.url();
            URL urlObj = new URL(url);
            String path = urlObj.getPath();
            byte[] body = request.body();
            event.setName(path);
            event.setUrl(url);
            event.setHeaders(JSON.toJSONString((Object)request.headers()));
            event.setMethod(request.method());
            if (body != null) {
                event.setRequestText(new String(body, StandardCharsets.UTF_8));
                event.setRequestSize(body.length);
            }
        }
        catch (Throwable throwable) {
            event.setMessage("(\u524d)\u6536\u96c6Feign\u6267\u884c\u65e5\u5fd7\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
    }

    private void afterExecute(HttpLogEvent event, Response response) {
        try {
            event.setHttpStatus(response.status() + "");
            event.setResponseHeader(JSON.toJSONString((Object)response.headers()));
            byte[] bodyBytes = IOUtils.toByteArray((InputStream)response.body().asInputStream());
            event.setResponseText(new String(bodyBytes, StandardCharsets.UTF_8));
            event.setResponseSize(bodyBytes.length);
        }
        catch (Throwable throwable) {
            event.setMessage("(\u540e)\u6536\u96c6feign\u6267\u884c\u65e5\u5fd7\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
    }
}

