/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.rabbitmq.model;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.MethodListener;
import com.xforceplus.xlog.core.model.impl.RabbitMqProducerLogEvent;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;

public class XlogRabbitMqProducerListenerImpl
implements MethodListener {
    private static final ThreadLocal<RabbitMqProducerLogEvent> cache = new ThreadLocal();
    private final LogSender logSender;
    private final String storeName;

    public XlogRabbitMqProducerListenerImpl(LogSender logSender, String storeName) {
        this.logSender = logSender;
        this.storeName = storeName;
    }

    public void beforeCall(Object target, Object[] args) {
        String traceId = LogContext.getTraceId();
        RabbitMqProducerLogEvent event = new RabbitMqProducerLogEvent();
        cache.set(event);
        event.setStoreName(this.storeName);
        event.setTraceId(traceId);
        event.setParentTraceId(LogContext.getParentTraceId());
        event.setTenantInfo(LogContext.getTenantInfo());
        try {
            String exchange = (String)args[1];
            String routingKey = (String)args[2];
            Message message = (Message)args[3];
            MessageProperties properties = message.getMessageProperties();
            String messageId = (String)StringUtils.defaultIfBlank((CharSequence)properties.getMessageId(), (CharSequence)traceId);
            properties.setMessageId(messageId);
            properties.setHeader("X-Trace-Id", (Object)traceId);
            event.setName(String.format("%s:%s", exchange, routingKey).replaceFirst("^:", ""));
            event.setMessageId(messageId);
            event.setMessageProperties(JSON.toJSONString((Object)properties.getHeaders()));
            byte[] body = message.getBody();
            if (body != null) {
                event.setMessageText(new String(body, StandardCharsets.UTF_8));
                event.setMessageTextSize(body.length);
            }
            event.setExchange(exchange);
            event.setRoutingKey(routingKey);
        }
        catch (Throwable throwable) {
            event.setMessage("[Before]\u6536\u96c6RabbitMqProducer\u65e5\u5fd7\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
    }

    public Object afterCall(Object target, Object[] args, Object result) {
        RabbitMqProducerLogEvent event = cache.get();
        cache.remove();
        this.logSender.send((LogEvent)event);
        return result;
    }

    public void onException(Object target, Throwable ex) {
        RabbitMqProducerLogEvent event = cache.get();
        cache.remove();
        event.setThrowable(ex);
        this.logSender.send((LogEvent)event);
    }
}

