/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.resttemplate.model;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.impl.HttpLogEvent;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.core.utils.IOUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.resttemplate.model.XlogClientHttpResponseWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class XlogRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final LogSender logSender;
    private final XlogProperties properties;

    public XlogRequestInterceptor(XlogProperties properties, LogSender logSender) {
        this.properties = properties;
        this.logSender = logSender;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        XlogClientHttpResponseWrapper clientHttpResponse;
        if (!(request instanceof ClientHttpRequest)) {
            return execution.execute(request, body);
        }
        ClientHttpRequest clientHttpRequest = (ClientHttpRequest)request;
        String traceId = LogContext.getTraceId();
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            clientHttpRequest.getHeaders().set("X-Trace-Id", traceId);
        }
        HttpLogEvent event = new HttpLogEvent();
        event.setStoreName(this.properties.getStoreName());
        event.setType("RPC");
        event.setTraceId(traceId);
        event.setParentTraceId(LogContext.getParentTraceId());
        event.setUserAgent("RestTemplate");
        event.setTenantInfo(LogContext.getTenantInfo());
        this.beforeExecute(event, clientHttpRequest, body);
        try {
            ClientHttpResponse originalResponse = execution.execute(request, body);
            byte[] responseBodyBytes = IOUtil.toByteArray((InputStream)originalResponse.getBody());
            clientHttpResponse = new XlogClientHttpResponseWrapper(originalResponse, responseBodyBytes);
        }
        catch (Throwable throwable) {
            event.setThrowable(throwable);
            this.logSender.send((LogEvent)event);
            throw throwable;
        }
        this.afterExecute(event, (ClientHttpResponse)clientHttpResponse);
        this.logSender.send((LogEvent)event);
        return clientHttpResponse;
    }

    private void beforeExecute(HttpLogEvent event, ClientHttpRequest clientHttpRequest, byte[] body) {
        try {
            URI uri = clientHttpRequest.getURI();
            event.setName(uri.getPath());
            event.setUrl(uri.toURL().toString());
            event.setHeaders(JSON.toJSONString((Object)clientHttpRequest.getHeaders()));
            event.setMethod((String)Optional.ofNullable(clientHttpRequest.getMethod()).map(Enum::name).orElse(null));
            if (body != null) {
                event.setRequestText(new String(body, StandardCharsets.UTF_8));
                event.setRequestSize(body.length);
            }
        }
        catch (Throwable throwable) {
            event.setMessage("(\u524d)\u6536\u96c6RestTemplate\u6267\u884c\u65e5\u5fd7\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
    }

    private void afterExecute(HttpLogEvent event, ClientHttpResponse clientHttpResponse) {
        try {
            event.setHttpStatus(clientHttpResponse.getStatusCode().toString());
            event.setResponseHeader(JSON.toJSONString((Object)clientHttpResponse.getHeaders()));
            byte[] bodyBytes = IOUtil.toByteArray((InputStream)clientHttpResponse.getBody());
            event.setResponseText(new String(bodyBytes, StandardCharsets.UTF_8));
            event.setResponseSize(bodyBytes.length);
        }
        catch (Throwable throwable) {
            event.setMessage("(\u540e)\u6536\u96c6RestTemplate\u6267\u884c\u65e5\u5fd7\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)throwable));
        }
    }
}

