/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.setting.resttemplate;

import com.xforceplus.xlog.core.exception.XlogException;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogSettingProperties;
import com.xforceplus.xlog.springboot.autoconfiguration.model.setting.XlogSettings;
import com.xforceplus.xlog.springboot.setting.resttemplate.XlogSettingRestTemplate;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.yaml.snakeyaml.Yaml;

public class XlogSettingWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(XlogSettingWorker.class);
    private static final Yaml yaml = new Yaml();
    private final XlogSettingRestTemplate restTemplate = new XlogSettingRestTemplate();
    private final XlogSettingProperties settingProperties;
    private final XlogSettings xlogSettings;

    public XlogSettingWorker(XlogSettingProperties settingProperties, XlogSettings xlogSettings) {
        this.settingProperties = settingProperties;
        this.xlogSettings = xlogSettings;
    }

    public void runImmediately() {
        String url = this.settingProperties.getUrl();
        this.runImmediately(url);
    }

    public void runImmediately(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new XlogException("xlog.setting.url \u5730\u5740\u4e0d\u53ef\u4ee5\u4e3a\u7a7a!");
        }
        String data = (String)this.restTemplate.getForObject(url, String.class, new Object[0]);
        if (StringUtils.isBlank((CharSequence)data)) {
            throw new XlogException(String.format("\u4ece %s \u62c9\u53d6\u5230\u7684\u6570\u636e\u4e3a\u7a7a!", url));
        }
        XlogSettings newXlogSettings = (XlogSettings)yaml.loadAs(data, XlogSettings.class);
        for (PropertyDescriptor propertyDescriptor : BeanUtils.getPropertyDescriptors(XlogSettings.class)) {
            Method readMethod = propertyDescriptor.getReadMethod();
            if (readMethod.getDeclaringClass() != XlogSettings.class) continue;
            BeanUtils.copyProperties((Object)readMethod.invoke((Object)newXlogSettings, new Object[0]), (Object)readMethod.invoke((Object)this.xlogSettings, new Object[0]));
        }
        log.info(String.format("XlogSettings \u4ece %s \u62c9\u53d6\u5230\u914d\u7f6e\u6570\u636e\n%s", url, data));
        log.info(String.format("\u66f4\u65b0\u540e\u7684XlogSettings\uff1a\n%s", yaml.dump((Object)this.xlogSettings)));
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.sleep();
                    this.runImmediately();
                }
            }
            catch (Exception ex) {
                log.warn("XlogSetting\u914d\u7f6e\u6570\u636e\u62c9\u53d6\u7ebf\u7a0b\u9047\u5230\u5f02\u5e38!", (Throwable)ex);
                try {
                    this.sleep();
                    continue;
                }
                catch (Exception e) {
                    log.warn("XlogSetting\u7ebf\u7a0b\u4f11\u7720\u65f6\u9047\u5230\u5f02\u5e38!", (Throwable)ex);
                    continue;
                }
            }
            break;
        }
    }

    private void sleep() {
        int pollingMilliSeconds = Math.max(this.settingProperties.getPollingSeconds(), 15) * 1000;
        Thread.sleep(pollingMilliSeconds);
    }
}

