/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.webmvc.model;

import com.xforceplus.xlog.core.utils.ExceptionUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class XlogHttpServletResponse
extends HttpServletResponseWrapper {
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    public XlogHttpServletResponse(HttpServletResponse response) {
        super(response);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        final ServletOutputStream servletOutputStream = super.getOutputStream();
        return new ServletOutputStream(){

            public boolean isReady() {
                return servletOutputStream.isReady();
            }

            public void setWriteListener(WriteListener writeListener) {
                servletOutputStream.setWriteListener(writeListener);
            }

            public void write(int b) throws IOException {
                servletOutputStream.write(b);
                XlogHttpServletResponse.this.outputStream.write(b);
            }
        };
    }

    public String getBody() {
        try {
            return this.outputStream.toString(StandardCharsets.UTF_8.name());
        }
        catch (Throwable e) {
            return "\u83b7\u53d6\u54cd\u5e94\u62a5\u6587\u4f53\u65f6\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)e);
        }
    }

    public int getBodySize() {
        return this.outputStream.size();
    }
}

