/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.springboot.webmvc.model;

import com.google.common.collect.Lists;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.TenantInfo;
import com.xforceplus.xlog.core.model.impl.HttpLogEvent;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.core.utils.JwtUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogApiProperties;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.autoconfiguration.model.setting.XlogApiSettings;
import com.xforceplus.xlog.springboot.webmvc.model.XlogApiBeforeSendingEventHandler;
import com.xforceplus.xlog.springboot.webmvc.model.XlogApiErrorResponse;
import com.xforceplus.xlog.springboot.webmvc.model.XlogApiErrorResponseHandler;
import com.xforceplus.xlog.springboot.webmvc.model.XlogHttpServletRequest;
import com.xforceplus.xlog.springboot.webmvc.model.XlogHttpServletResponse;
import com.xforceplus.xlog.springboot.webmvc.model.impl.XlogDefaultApiErrorResponseHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.NestedServletException;

public class XlogWebFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(XlogWebFilter.class);
    private final String storeName;
    private final XlogApiSettings apiSettings;
    private final XlogApiProperties apiProperties;
    private Pattern pattern;
    private String urlPattern;
    private Pattern blackPattern;
    private String blackUrlPattern;
    private final LogSender logSender;
    private final XlogApiErrorResponseHandler apiErrorResponseHandler;
    private final XlogApiBeforeSendingEventHandler apiBeforeSendingEventHandler;
    private final XlogApiErrorResponseHandler defaultApiErrorResponseHandler = new XlogDefaultApiErrorResponseHandler();

    public XlogWebFilter(XlogProperties properties, XlogApiSettings apiSettings, LogSender logSender, XlogApiErrorResponseHandler apiErrorResponseHandler, XlogApiBeforeSendingEventHandler apiBeforeSendingEventHandler) {
        this.storeName = properties.getStoreName();
        this.logSender = logSender;
        this.apiErrorResponseHandler = apiErrorResponseHandler;
        this.apiBeforeSendingEventHandler = apiBeforeSendingEventHandler;
        this.apiSettings = apiSettings;
        this.apiProperties = properties.getApi();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String uri = ((HttpServletRequest)servletRequest).getRequestURI();
        if (!this.isMatch(uri)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        XlogHttpServletRequest request = new XlogHttpServletRequest((HttpServletRequest)servletRequest);
        XlogHttpServletResponse response = new XlogHttpServletResponse((HttpServletResponse)servletResponse);
        this.doActualFilter(filterChain, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doActualFilter(FilterChain filterChain, XlogHttpServletRequest request, XlogHttpServletResponse response) throws IOException, ServletException {
        LogContext.init();
        if (request.getHeader("X-Trace-Id") != null) {
            LogContext.setParentTraceId((String)request.getHeader("X-Trace-Id"));
        }
        HttpLogEvent event = new HttpLogEvent();
        event.setHeaders(this.requestHeaders2String((HttpServletRequest)request));
        event.setRequestText(request.getBody());
        event.setRequestSize(request.getBodySize());
        event.setMethod(request.getMethod());
        event.setName(request.getRequestURI());
        event.setRemoteIp(request.getRemoteHost());
        event.setUrl(this.getFullUrl(request));
        event.setUserAgent(request.getHeader("user-agent"));
        event.setStoreName(this.storeName);
        event.setType("Api");
        event.setTraceId(LogContext.getTraceId());
        event.setParentTraceId(LogContext.getParentTraceId());
        try {
            LogContext.setTenantInfo((TenantInfo)this.calcTenantInfo(this.getUserCenterToken((HttpServletRequest)request)));
        }
        catch (Throwable ex) {
            event.setMessage(String.format("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38\uff01%s", ExceptionUtil.toDesc((Throwable)ex)));
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            Throwable exceptionHandlerThrowable = (Throwable)request.getAttribute("api.request.attribute.controller.advice.exception");
            if (exceptionHandlerThrowable != null) {
                log.debug("\u53d1\u73b0API\u53d7\u63a7\u5f02\u5e38", exceptionHandlerThrowable);
                event.setThrowable(exceptionHandlerThrowable);
                request.removeAttribute("api.request.attribute.controller.advice.exception");
            }
        }
        catch (Throwable ex) {
            log.debug("\u53d1\u751fAPI\u8c03\u7528\u5f02\u5e38", ex);
            Throwable throwable = ex;
            if (ex instanceof NestedServletException && ex.getCause() != null) {
                throwable = ex.getCause();
            }
            event.setThrowable(throwable);
            this.handleErrorResponse(response, event, throwable);
        }
        finally {
            event.fetchContext();
            String contentType = response.getContentType();
            if (contentType != null && !contentType.contains("image") && !contentType.contains("zip")) {
                event.setResponseText(response.getBody());
            }
            event.setResponseSize(response.getBodySize());
            event.setHttpStatus(response.getStatus() + "");
            if (this.beforeSend(event)) {
                this.logSender.send((LogEvent)event);
            }
            LogContext.clear();
        }
    }

    private boolean beforeSend(HttpLogEvent event) {
        if (this.apiBeforeSendingEventHandler == null) {
            return true;
        }
        try {
            return this.apiBeforeSendingEventHandler.handle(event);
        }
        catch (Throwable throwable) {
            event.setMessage("\u53d1\u9001\u524d\u7684\u56de\u8c03\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff01" + ExceptionUtil.toDesc((Throwable)throwable));
            return true;
        }
    }

    private void handleErrorResponse(XlogHttpServletResponse response, HttpLogEvent event, Throwable throwable) {
        try {
            XlogApiErrorResponse errorResponse = this.apiErrorResponseHandler != null ? this.apiErrorResponseHandler.handle(event, throwable) : this.defaultApiErrorResponseHandler.handle(event, throwable);
            response.setHeader("Content-Type", "application/json; charset=UTF-8");
            response.setStatus(errorResponse.getHttpStatusCode());
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(errorResponse.getResponseBody().getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Xlog: WriteErrorResponse Exception!", throwable);
        }
    }

    private boolean isMatch(String uri) {
        this.calcUrlPattern();
        if (this.blackPattern == null) {
            return this.pattern.matcher(uri).matches();
        }
        return this.pattern.matcher(uri).matches() && !this.blackPattern.matcher(uri).matches();
    }

    private String getFullUrl(XlogHttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (requestURL == null) {
            return "";
        }
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            return String.format("%s?%s", requestURL, queryString);
        }
        return requestURL.toString();
    }

    @Nullable
    private Pair<String, String> getUserCenterToken(HttpServletRequest request) {
        String key = "x-access-token";
        String tokenStr = request.getHeader(key);
        if (StringUtils.isNotBlank((CharSequence)tokenStr)) {
            return Pair.of((Object)key, (Object)tokenStr);
        }
        key = "xforce-saas-token";
        tokenStr = request.getHeader(key);
        if (StringUtils.isNotBlank((CharSequence)tokenStr)) {
            return Pair.of((Object)key, (Object)tokenStr);
        }
        key = "xforce-saas-token";
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            String cookieName = key;
            Cookie cookie = Arrays.stream(cookies).filter(t -> t.getName().equals(cookieName)).findFirst().orElse(null);
            if (cookie != null) {
                return Pair.of((Object)key, (Object)cookie.getValue());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(tokenStr = request.getHeader(key = "x-app-token")))) {
            return Pair.of((Object)key, (Object)tokenStr);
        }
        return null;
    }

    private TenantInfo calcTenantInfo(Pair<String, String> pair) {
        if (pair == null) {
            return null;
        }
        return JwtUtil.calc((String)((String)pair.getLeft()), (String)((String)pair.getRight()));
    }

    private String requestHeaders2String(HttpServletRequest request) {
        ArrayList headerList = Lists.newArrayList();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames != null && headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headers = request.getHeaders(headerName);
            while (headers != null && headers.hasMoreElements()) {
                headerList.add(String.format("%s: %s", headerName, headers.nextElement()));
            }
        }
        return StringUtils.join((Iterable)headerList, (String)"\n");
    }

    private void calcUrlPattern() {
        if (this.apiSettings != null) {
            if (!Objects.equals(this.apiSettings.getUrlPattern(), this.urlPattern)) {
                this.urlPattern = StringUtils.isBlank((CharSequence)this.apiSettings.getUrlPattern()) ? ".*" : this.apiSettings.getUrlPattern();
                this.pattern = Pattern.compile(this.urlPattern);
            }
            if (!Objects.equals(this.apiSettings.getBlackUrlPattern(), this.blackUrlPattern)) {
                this.blackUrlPattern = this.apiSettings.getBlackUrlPattern();
                this.blackPattern = StringUtils.isBlank((CharSequence)this.blackUrlPattern) ? null : Pattern.compile(this.blackUrlPattern);
            }
        } else if (this.apiProperties != null && StringUtils.isNotBlank((CharSequence)this.apiProperties.getUrlPattern()) && !Objects.equals(this.apiProperties.getUrlPattern(), this.urlPattern)) {
            this.urlPattern = this.apiProperties.getUrlPattern();
            this.pattern = Pattern.compile(this.urlPattern);
        }
        if (StringUtils.isBlank((CharSequence)this.urlPattern)) {
            this.urlPattern = ".*";
            this.pattern = Pattern.compile(this.urlPattern);
        }
    }
}

