package com.xforceplus.xlog.springboot.autoconfiguration.feign;

import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.feign.model.XlogFeignInterceptor;
import feign.Feign;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Feign配置器
 *
 * @author gulei
 * @date 2023/01/19
 */
@Configuration
@AutoConfigureAfter(XlogAutoConfiguration.class)
@ConditionalOnClass({Feign.class, LoadBalancerFeignClient.class})
@ConditionalOnProperty(prefix = "xlog", name = {"enabled", "rpc.feign.enabled"}, havingValue = "true")
public class XlogFeignConfiguration {
    private final XlogProperties xlogProperties;

    /**
     * 构造函数
     *
     * @param xlogProperties xlog配置
     */
    @Autowired
    public XlogFeignConfiguration(final XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    /**
     * 注入Feign拦截器实例
     *
     * @param logSender 日志发送器
     * @return Feign拦截器实例
     */
    @Bean
    @ConditionalOnMissingBean
    public XlogFeignAdvice feignInterceptor(final LogSender logSender) {
        return new XlogFeignAdvice(new XlogFeignInterceptor(logSender, this.xlogProperties.getStoreName()));
    }
}
