package com.xforceplus.xlog.springboot.autoconfiguration.messagebus;

import com.xforceplus.janus.message.sdk.MBClient;
import com.xforceplus.xlog.core.model.MethodListener;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.messagebus.model.impl.MessageBusProducerListenerImpl;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import lombok.SneakyThrows;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.lang.reflect.Field;

/**
 * 消息总线生产者配置器
 *
 * @author gulei
 * @date 2023/01/19
 */
@Configuration
@ConditionalOnClass(MBClient.class)
@AutoConfigureAfter(XlogAutoConfiguration.class)
@ConditionalOnProperty(prefix = "xlog", name = {"enabled", "message-bus.producer.enabled"}, havingValue = "true")
public class XlogMessageBusProducerConfiguration {
    private final XlogProperties xlogProperties;

    /**
     * 构造函数
     *
     * @param xlogProperties xlog配置
     */
    public XlogMessageBusProducerConfiguration(final XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    /**
     * 注入消息总线生产者监听器实例
     *
     * @param logSender 日志发送者
     * @return 消息总线生产者监听器实例
     */
    @Bean("messageBusProducerListener")
    @ConditionalOnMissingBean
    @SneakyThrows
    public MethodListener xlogMessageBusProducerListener(final LogSender logSender) {
        final MethodListener listener = new MessageBusProducerListenerImpl(logSender, this.xlogProperties.getStoreName());
        final Field listenerField = MBClient.class.getDeclaredField("_listener");
        listenerField.set(MBClient.class, listener);
        return listener;
    }
}
