package com.xforceplus.xlog.springboot.autoconfiguration.sqs;

import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.sqs.model.SqsConsumerInterceptor;
import com.xforceplus.xplat.aws.SqsData;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class XlogSqsConsumerAdvice {
    private final SqsConsumerInterceptor sqsConsumerInterceptor;

    public XlogSqsConsumerAdvice(final LogSender logSender, final XlogProperties xlogProperties) {
        this.sqsConsumerInterceptor = new SqsConsumerInterceptor(logSender, xlogProperties.getStoreName());
    }

    @Around("execution (* com.xforceplus.xplat.aws.sqs.listener.AbsSQSListener.cusListener(..))")
    public Object cut(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        final SqsData sqsData = (SqsData)proceedingJoinPoint.getArgs()[0];
        return sqsConsumerInterceptor.intercept(sqsData, () -> (Boolean)proceedingJoinPoint.proceed());
    }
}
