package com.xforceplus.xlog.springboot.autoconfiguration.sqs;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.model.MethodListener;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xforceplus.xlog.springboot.autoconfiguration.XlogAutoConfiguration;
import com.xforceplus.xlog.springboot.autoconfiguration.model.XlogProperties;
import com.xforceplus.xlog.springboot.rabbitmq.model.XlogRabbitMqProducerListenerImpl;
import com.xforceplus.xlog.sqs.model.impl.SqsProducerListenerImpl;
import com.xforceplus.xplat.aws.sqs.SqsService;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.lang.reflect.Field;

@Slf4j
@Configuration
@ConditionalOnClass({SqsService.class})
@AutoConfigureAfter(XlogAutoConfiguration.class)
@ConditionalOnProperty(prefix = "xlog", name = {"enabled", "sqs.producer.enabled"}, havingValue = "true")
public class XlogSqsProducerConfiguration {
    private final XlogProperties xlogProperties;

    @Autowired
    public XlogSqsProducerConfiguration(final XlogProperties xlogProperties) {
        this.xlogProperties = xlogProperties;
    }

    @Bean("xlogSqsProducerListener")
    @ConditionalOnMissingBean(name = "xlogSqsProducerListener")
    @SneakyThrows
    public MethodListener xlogSqsProducerListener(final LogSender logSender) {
        final MethodListener listener = new SqsProducerListenerImpl(logSender, this.xlogProperties.getStoreName());
        final Field listenerField = SqsService.class.getDeclaredField("_listener");
        listenerField.set(SqsService.class, listener);
        log.info(String.format("xlog.sqs.producer已启动... 参数: %s", JSON.toJSONString(this.xlogProperties.getSqs().getProducer())));
        return listener;
    }
}
