package com.xforceplus.xlog.springboot.rabbitmq;

import com.xforceplus.xlog.core.utils.JavassistUtil;
import com.xforceplus.xlog.springboot.rabbitmq.model.XlogRabbitMqConsumerListenerImpl;
import com.xforceplus.xlog.springboot.rabbitmq.model.XlogRabbitMqProducerListenerImpl;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class XlogRabbitMqPreparing {
    public static void prepareProducer() {
        final String rabbitmqTemplateClassName = "org.springframework.amqp.rabbit.core.RabbitTemplate";
        final String rabbitmqTemplateMethodName = "doSend";

        try {
            JavassistUtil.installListener(rabbitmqTemplateClassName, rabbitmqTemplateMethodName, XlogRabbitMqProducerListenerImpl.class);

            log.info(String.format("%s 已完成字节码变更处理并载入到ClassLoader中...", rabbitmqTemplateClassName));
        } catch (Exception ex) {
            log.error(String.format("%s 字节码变更失败...", rabbitmqTemplateClassName), ex);
        }
    }

    public static void prepareConsumer() {
        final String rabbitmqListenerAdapterClassName = "org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter";
        final String rabbitmqListenerAdapterMethodName = "onMessage";

        try {
            JavassistUtil.installListener(rabbitmqListenerAdapterClassName, rabbitmqListenerAdapterMethodName, XlogRabbitMqConsumerListenerImpl.class);

            log.info(String.format("%s 已完成字节码变更处理并载入到ClassLoader中...", rabbitmqListenerAdapterClassName));
        } catch (Exception ex) {
            log.error(String.format("%s 字节码变更失败...", rabbitmqListenerAdapterClassName), ex);
        }
    }
}
