package com.xforceplus.xlog.springboot.autoconfiguration.model;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Xlog根配置
 *
 * @author gulei
 * @date 2023/01/19
 */
@Data
@ConfigurationProperties(prefix = "xlog")
public class XlogProperties {
    private boolean enabled = false;
    private String storeName;
    private XlogSettingProperties setting = new XlogSettingProperties();
    private XlogSenderProperties logSender = new XlogSenderProperties();
    private XlogApiProperties api = new XlogApiProperties();
    private XlogRpcProperties rpc = new XlogRpcProperties();
    private XlogObjectSenderProperties objectSender = new XlogObjectSenderProperties();
    private XlogSqsProperties sqs = new XlogSqsProperties();
    private XlogMessageBusProperties messageBus = new XlogMessageBusProperties();
    private XlogRabbitMqProperties rabbitMq = new XlogRabbitMqProperties();
    private XlogStandaloneProperties standalone = new XlogStandaloneProperties();
    private XlogMyBatisProperties mybatis = new XlogMyBatisProperties();
    private XlogScheduleProperties schedule = new XlogScheduleProperties();
    private XlogUltramanProperties ultraman = new XlogUltramanProperties();
}
