package com.xforceplus.xlog.springboot.autoconfiguration.standalone;

import com.xforceplus.apollo.janus.standalone.sdk.annotation.GlobalEventListener;
import com.xforceplus.xlog.standalone.model.StandaloneConsumerInterceptor;
import com.xforceplus.xlog.standalone.model.StandaloneMessageData;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.annotation.AnnotationUtils;

import java.util.Map;

/**
 * Standalone消费者通知器
 *
 * @author gulei
 * @date 2023/1/20
 */
@Aspect
public class XlogStandaloneConsumerAdvice2 {
    private final StandaloneConsumerInterceptor interceptor;

    /**
     * 构造函数
     *
     * @param interceptor 拦截器
     */
    public XlogStandaloneConsumerAdvice2(final StandaloneConsumerInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    /**
     * 切点
     *
     * @param proceedingJoinPoint 执行点
     * @return 执行结果
     * @throws Throwable 异常
     */
    @Around("@within(com.xforceplus.apollo.janus.standalone.sdk.annotation.GlobalEventListener)")
    public Object cut(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        final String methodName = proceedingJoinPoint.getSignature().getName();
        final Object target = proceedingJoinPoint.getTarget();

        if (!"onMessage".equals(methodName) && !"onMessageWithResult".equals(methodName)) {
            return proceedingJoinPoint.proceed();
        }

        final Object queueName = AnnotationUtils.getValue(target.getClass().getAnnotation(GlobalEventListener.class), "eventType");

        final Object[] args = proceedingJoinPoint.getArgs();

        final StandaloneMessageData standaloneMessageData = new StandaloneMessageData();
        standaloneMessageData.setEventType(String.valueOf(queueName));
        if (args[0] instanceof String) {
            standaloneMessageData.setMessageId((String) args[0]);
        }
        if (args[1] instanceof Map) {
            standaloneMessageData.setHeaders((Map) args[1]);
        }
        if (args[2] instanceof String) {
            standaloneMessageData.setMessageBody((String) args[2]);
        }
        if (args[3] instanceof String) {
            standaloneMessageData.setSource((String) args[3]);
        }

        return this.interceptor.intercept(standaloneMessageData, proceedingJoinPoint::proceed);
    }
}
