package com.xforceplus.xlog.xxljob;

import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.impl.XxlJobLogEvent;
import com.xforceplus.xlog.core.utils.JavassistUtil;
import lombok.extern.slf4j.Slf4j;

/**
 * XxlJobPreparing
 *
 * @author gulei
 * @date 2023/08/17
 */
@Slf4j
public class XxlJobPreparing {
    private XxlJobPreparing() {
        throw new IllegalStateException("Utility class");
    }

    /**
     * 准备
     */
    public static void prepare() {
        final String clazzName = "com.xxl.job.core.handler.impl.MethodJobHandler";
        final String methodName = "execute";

        try {
            final boolean result = JavassistUtil.installEventListener(clazzName, methodName, MethodEventListener.class, XxlJobLogEvent.class);

            if (result) {
                log.info(String.format("%s 已完成字节码变更处理并载入到ClassLoader中...", clazzName));
            }
        } catch (Exception e) {
            log.error(String.format("%s 字节码变更失败...", clazzName), e);
        }
    }
}
