/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xlog.xxljob.model.impl;

import com.alibaba.fastjson.JSON;
import com.xforceplus.xlog.core.model.LogContext;
import com.xforceplus.xlog.core.model.LogEvent;
import com.xforceplus.xlog.core.model.MethodEventListener;
import com.xforceplus.xlog.core.model.impl.XxlJobLogEvent;
import com.xforceplus.xlog.core.model.setting.XlogXxlJobSettings;
import com.xforceplus.xlog.core.utils.ExceptionUtil;
import com.xforceplus.xlog.logsender.model.LogSender;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.handler.impl.MethodJobHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class XlogMethodJobHandlerListenerImpl
extends MethodEventListener {
    private static final Map<Object, String> JOB_NAME_CACHE = new ConcurrentHashMap<Object, String>();
    private final LogSender logSender;
    private final String storeName;
    private final XlogXxlJobSettings settings;

    public XlogMethodJobHandlerListenerImpl(LogSender logSender, String storeName, XlogXxlJobSettings settings) {
        this.logSender = logSender;
        this.storeName = storeName;
        this.settings = settings;
    }

    public void beforeCall(Object target, LogEvent logEvent, Object[] args) {
        if (!(logEvent instanceof XxlJobLogEvent)) {
            return;
        }
        LogContext.init();
        XxlJobLogEvent event = (XxlJobLogEvent)logEvent;
        try {
            event.setTraceId(LogContext.getTraceId());
            if (target instanceof MethodJobHandler) {
                event.setName(this.calcJobName((MethodJobHandler)target));
            }
            event.setStoreName(this.storeName);
            String requestText = args.length > 0 && args[0] instanceof String ? (String)args[0] : null;
            Boolean isIgnoreRequestText = Optional.ofNullable(this.settings).map(XlogXxlJobSettings::isIgnoreRequestText).orElse(false);
            if (!isIgnoreRequestText.booleanValue()) {
                event.setRequestText(requestText);
            }
            if (requestText != null) {
                event.setRequestSize(requestText.getBytes(StandardCharsets.UTF_8).length);
            }
        }
        catch (Throwable ex) {
            event.setWarnMessage(String.format("[Before]\u6536\u96c6XxlJob\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: %s", ExceptionUtil.toDesc((Throwable)ex)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object afterCall(Object target, LogEvent logEvent, Object[] args, Object result) {
        if (!(logEvent instanceof XxlJobLogEvent)) {
            return result;
        }
        XxlJobLogEvent event = (XxlJobLogEvent)logEvent;
        try {
            if (result == null) {
                Object object = result;
                return object;
            }
            String responseText = JSON.toJSONString((Object)result);
            Boolean isIgnoreResponseText = Optional.ofNullable(this.settings).map(XlogXxlJobSettings::isIgnoreResponseText).orElse(false);
            if (!isIgnoreResponseText.booleanValue()) {
                event.setResponseText(responseText);
            }
            event.setResponseSize(responseText.getBytes(StandardCharsets.UTF_8).length);
            Object object = result;
            return object;
        }
        catch (Throwable ex) {
            event.setWarnMessage("[After]\u6536\u96c6XxlJob\u65e5\u5fd7\u6570\u636e\u5f02\u5e38: " + ExceptionUtil.toDesc((Throwable)ex));
            Object object = result;
            return object;
        }
        finally {
            event.fetchContext();
            this.logSender.send((LogEvent)event);
        }
    }

    public void onException(Object target, LogEvent logEvent, Throwable ex) {
        if (!(logEvent instanceof XxlJobLogEvent)) {
            return;
        }
        XxlJobLogEvent event = (XxlJobLogEvent)logEvent;
        event.setThrowable(ex);
        event.fetchContext();
        this.logSender.send((LogEvent)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String calcJobName(MethodJobHandler target) {
        if (JOB_NAME_CACHE.containsKey(target)) return JOB_NAME_CACHE.get(target);
        Class<XlogMethodJobHandlerListenerImpl> clazz = XlogMethodJobHandlerListenerImpl.class;
        synchronized (XlogMethodJobHandlerListenerImpl.class) {
            if (JOB_NAME_CACHE.containsKey(target)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return JOB_NAME_CACHE.get(target);
            }
            Field field = target.getClass().getDeclaredField("method");
            field.setAccessible(true);
            Object theMethod = field.get(target);
            if (theMethod instanceof Method) {
                XxlJob anno = ((Method)theMethod).getDeclaredAnnotation(XxlJob.class);
                JOB_NAME_CACHE.put(target, anno == null ? "unknown" : anno.value());
            } else {
                JOB_NAME_CACHE.put(target, "unknown");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return JOB_NAME_CACHE.get(target);
        }
    }
}

