/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xplat.aws.boot2;

import com.xforceplus.xplat.aws.boot2.DefaultSqsListener;
import com.xforceplus.xplat.aws.boot2.SQSListenerHandler;
import com.xforceplus.xplat.aws.s3.S3Service;
import com.xforceplus.xplat.aws.s3.singleton.S3ClientSingleton;
import com.xforceplus.xplat.aws.spring.utils.SpringBootAssit;
import com.xforceplus.xplat.aws.sqs.SqsService;
import com.xforceplus.xplat.aws.sqs.listener.AbsSQSListener;
import com.xforceplus.xplat.aws.sqs.singleton.SqsClientSingleton;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import net.wicp.tams.common.Conf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@Order(value=-2147483648)
public class ConfigInit {
    private static final Logger log = LoggerFactory.getLogger(ConfigInit.class);
    public static ApplicationContext context;
    @Autowired
    private SpringBootAssit springBootAssit;
    private String[] addPre = new String[]{"xplat.aws.session.", "common.apiext.thread.pool."};
    private String[] addSingle = new String[0];

    public ConfigInit() {
        log.info("ConfigInit -----------constructor");
    }

    @PostConstruct
    private void init() {
        Properties inputpamas = new Properties();
        Properties tpProps = Conf.copyProperties();
        this.addOtherConf(tpProps);
        Map allMap = this.springBootAssit.findAllProps();
        for (String keystr : allMap.keySet()) {
            boolean needAdd = tpProps.containsKey(keystr);
            if (!needAdd) {
                for (String addPreEle : this.addPre) {
                    if (!keystr.startsWith(addPreEle)) continue;
                    needAdd = true;
                    break;
                }
            }
            if (!needAdd) continue;
            inputpamas.put(keystr, allMap.get(keystr));
        }
        log.info("input parmas:{}", (Object)inputpamas.toString());
        Conf.overProp((Properties)inputpamas);
    }

    private void addOtherConf(Properties tpProps) {
        for (String needAddConf : this.addSingle) {
            if (tpProps.containsKey(needAddConf)) continue;
            tpProps.put(needAddConf, "null");
        }
    }

    @Bean
    public SqsService newSqs() {
        return SqsClientSingleton.getInst().getSqs();
    }

    @Bean
    public S3Service newS3() {
        return S3ClientSingleton.getInst().getS3();
    }

    @Bean
    public AbsSQSListener defaultSqsListener() {
        return new DefaultSqsListener();
    }

    @Bean
    @ConditionalOnProperty(name={"xplat.aws.profile.channel"}, havingValue="standalone")
    public SQSListenerHandler sqsListenerHandler() {
        return new SQSListenerHandler();
    }

    @Configuration
    @Order(value=-2147483648)
    protected class InitContext
    implements ApplicationContextAware {
        protected InitContext() {
        }

        public void setApplicationContext(ApplicationContext arg0) throws BeansException {
            context = arg0;
        }
    }
}

