/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xplat.aws.boot2;

import com.xforceplus.xplat.aws.cache.MessageCache;
import com.xforceplus.xplat.aws.spring.annotation.SQSListener;
import com.xforceplus.xplat.aws.spring.utils.SpringBootAssit;
import com.xforceplus.xplat.aws.sqs.SqsService;
import com.xforceplus.xplat.aws.sqs.SqsStandaloneServiceImpl;
import com.xforceplus.xplat.aws.sqs.listener.AbsSQSListener;
import com.xforceplus.xplat.aws.sqs.singleton.SqsClientSingleton;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.apiext.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class SQSListenerHandler
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(SQSListenerHandler.class);
    @Autowired
    private List<AbsSQSListener> sqsListeners;
    @Autowired
    private SqsService sqs;
    @Autowired
    private SpringBootAssit springBootAssit;
    private Map<String, AbsSQSListener> sqsListenerMap = new HashMap<String, AbsSQSListener>();

    public void afterPropertiesSet() throws Exception {
        log.info("afterPropertiesSet {} ,{} ", (Object)(this.sqsListeners == null ? 1 : 0), (Object)(this.sqs == null ? 1 : 0));
        if (null != this.sqsListeners && this.sqsListeners.size() > 0) {
            this.sqsListeners.forEach(v -> {
                String queueName;
                if (v.getClass().isAnnotationPresent(SQSListener.class) && StringUtil.isNotNull((Object)(queueName = v.getClass().getAnnotation(SQSListener.class).queueName())) && !queueName.equals("default")) {
                    this.sqsListenerMap.put(queueName, (AbsSQSListener)v);
                }
            });
        }
        MessageCache.sqsListenerMap = this.sqsListenerMap;
        if (this.sqs != null && this.sqs instanceof SqsStandaloneServiceImpl) {
            SqsStandaloneServiceImpl standaloneService = (SqsStandaloneServiceImpl)this.sqs;
            standaloneService.startTask();
        }
    }

    public void destroy() throws Exception {
        SqsClientSingleton.getInst().getSqs().close();
    }
}

