/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xplat.bill.config.dao;

import com.baomidou.mybatisplus.spring.MybatisSqlSessionFactoryBean;
import java.io.IOException;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
public class SessionFactoryConfiguration {
    @Value(value="${mabatis_config_file}")
    private String mybatisConfigFilePath;
    @Value(value="${mapper_path}")
    private String mapperPath;
    @Value(value="${entity_package}")
    private String entityPackage;
    @Autowired
    @Qualifier(value="dataSource")
    private DataSource dataSource;

    @Bean(name={"sqlSessionFactory"})
    public MybatisSqlSessionFactoryBean crateSqlSessionFactoryBean() throws IOException {
        MybatisSqlSessionFactoryBean sqlSessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sqlSessionFactoryBean.setConfigLocation((Resource)new ClassPathResource(this.mybatisConfigFilePath));
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        String packageSearchPath = "classpath*:" + this.mapperPath;
        sqlSessionFactoryBean.setMapperLocations(resolver.getResources(packageSearchPath));
        sqlSessionFactoryBean.setDataSource(this.dataSource);
        sqlSessionFactoryBean.setTypeAliasesPackage(this.entityPackage);
        return sqlSessionFactoryBean;
    }
}

