/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xplat.bill.killbill.config;

import com.xforceplus.xplat.bill.killbill.config.KillbillProperties;
import org.killbill.billing.client.KillBillHttpClient;
import org.killbill.billing.client.RequestOptions;
import org.killbill.billing.client.api.gen.AccountApi;
import org.killbill.billing.client.api.gen.BundleApi;
import org.killbill.billing.client.api.gen.CatalogApi;
import org.killbill.billing.client.api.gen.CreditApi;
import org.killbill.billing.client.api.gen.InvoiceApi;
import org.killbill.billing.client.api.gen.InvoicePaymentApi;
import org.killbill.billing.client.api.gen.PaymentApi;
import org.killbill.billing.client.api.gen.PaymentGatewayApi;
import org.killbill.billing.client.api.gen.PaymentMethodApi;
import org.killbill.billing.client.api.gen.SubscriptionApi;
import org.killbill.billing.client.api.gen.TenantApi;
import org.killbill.billing.client.api.gen.UsageApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={KillbillProperties.class})
public class KillbillConfig {
    @Autowired
    KillbillProperties killbillProperties;

    @Bean
    @ConditionalOnMissingBean
    RequestOptions xpOptions() {
        return RequestOptions.builder().withCreatedBy("admin").withTenantApiKey("xforceplus").withTenantApiSecret("xforceplus").build();
    }

    @Bean
    KillBillHttpClient killBillHttpClient() {
        KillBillHttpClient client = new KillBillHttpClient(String.format("http://%s:%d", this.killbillProperties.getServerHost(), this.killbillProperties.getServerPort()), this.killbillProperties.username, this.killbillProperties.password, this.killbillProperties.apiKey, this.killbillProperties.apiSecret, this.killbillProperties.proxyHost, this.killbillProperties.proxyPort, this.killbillProperties.connectTimeOut, this.killbillProperties.readTimeOut, this.killbillProperties.requestTimeout);
        return client;
    }

    @Bean
    AccountApi accountApi(KillBillHttpClient killBillHttpClient) {
        return new AccountApi(killBillHttpClient);
    }

    @Bean
    TenantApi tenantApi(KillBillHttpClient killBillHttpClient) {
        return new TenantApi(killBillHttpClient);
    }

    @Bean
    CatalogApi catalogApi(KillBillHttpClient killBillHttpClient) {
        return new CatalogApi(killBillHttpClient);
    }

    @Bean
    BundleApi bundleApi(KillBillHttpClient killBillHttpClient) {
        return new BundleApi(killBillHttpClient);
    }

    @Bean
    SubscriptionApi subscriptionApi(KillBillHttpClient killBillHttpClient) {
        return new SubscriptionApi(killBillHttpClient);
    }

    @Bean
    InvoiceApi invoiceApi(KillBillHttpClient killBillHttpClient) {
        return new InvoiceApi(killBillHttpClient);
    }

    @Bean
    PaymentApi paymentApi(KillBillHttpClient killBillHttpClient) {
        return new PaymentApi(killBillHttpClient);
    }

    @Bean
    InvoicePaymentApi invoicePaymentApi(KillBillHttpClient killBillHttpClient) {
        return new InvoicePaymentApi(killBillHttpClient);
    }

    @Bean
    PaymentGatewayApi paymentGatewayApi(KillBillHttpClient killBillHttpClient) {
        return new PaymentGatewayApi(killBillHttpClient);
    }

    @Bean
    PaymentMethodApi paymentMethodApi(KillBillHttpClient killBillHttpClient) {
        return new PaymentMethodApi(killBillHttpClient);
    }

    @Bean
    UsageApi usageApi(KillBillHttpClient killBillHttpClient) {
        return new UsageApi(killBillHttpClient);
    }

    @Bean
    CreditApi creditApi(KillBillHttpClient killBillHttpClient) {
        return new CreditApi(killBillHttpClient);
    }
}

