/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xplat.bill.killbill.service.impl;

import com.google.common.collect.ImmutableList;
import com.xforceplus.xplat.bill.killbill.constant.KillbillConstant;
import com.xforceplus.xplat.bill.killbill.enums.KillbillExceptionEnum;
import com.xforceplus.xplat.bill.killbill.exception.KillbillServiceException;
import com.xforceplus.xplat.bill.killbill.service.KillbillAccountService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.client.KillBillClientException;
import org.killbill.billing.client.RequestOptions;
import org.killbill.billing.client.api.gen.AccountApi;
import org.killbill.billing.client.model.InvoicePayments;
import org.killbill.billing.client.model.PaymentMethods;
import org.killbill.billing.client.model.gen.Account;
import org.killbill.billing.client.model.gen.Invoice;
import org.killbill.billing.client.model.gen.Payment;
import org.killbill.billing.client.model.gen.PaymentMethod;
import org.killbill.billing.client.model.gen.PaymentMethodPluginDetail;
import org.killbill.billing.client.model.gen.PaymentTransaction;
import org.killbill.billing.payment.api.TransactionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class KillbillAccountServiceImpl
implements KillbillAccountService {
    private static Logger logger = LoggerFactory.getLogger(KillbillAccountServiceImpl.class);
    @Autowired
    AccountApi accountApi;

    @Override
    public Account getAccount(String accountId, RequestOptions options) {
        Account account = null;
        try {
            account = this.accountApi.getAccount(UUID.fromString(accountId), options);
        }
        catch (Exception e) {
            logger.error("[\u6839\u636e\u8d26\u53f7id\u67e5\u8be2killbill\u8d26\u53f7\u4fe1\u606f\u5931\u8d25]");
        }
        return account;
    }

    @Override
    public Account createAccount(String companyCode, String companyName, Long companyId, RequestOptions options) {
        logger.debug("createAccount param is :companyCode-->{},companyName-->{},companyId-->{}", new Object[]{companyCode, companyName, companyId});
        Account result = null;
        try {
            Account body = new Account();
            body.setName(companyCode);
            if (null == companyCode) {
                body.setFirstNameLength(Integer.valueOf(0));
            } else {
                body.setFirstNameLength(Integer.valueOf(companyCode.length()));
            }
            body.setCurrency(Currency.CNY);
            body.setTimeZone("Asia/Shanghai");
            body.setCountry("CN");
            body.setLocale("zh_CN");
            body.setReferenceTime(new DateTime().withTimeAtStartOfDay());
            body.setBillCycleDayLocal(Integer.valueOf(1));
            body.setCompany(companyName);
            body.setExternalKey(companyId + "_" + System.currentTimeMillis());
            result = this.accountApi.createAccount(body, options);
            logger.debug("accountApi.createAccount result is :{},{}", (Object)result.getAccountId(), (Object)result.getName());
            this.addPaymentMethod(result.getAccountId(), result.getName(), options);
        }
        catch (KillBillClientException e) {
            logger.error("createAccount KillBillClientException", (Throwable)e);
            throw new KillbillServiceException(KillbillExceptionEnum.ERROR_CREATE_ACCOUNT.getCode(), KillbillExceptionEnum.ERROR_CREATE_ACCOUNT.getMessage());
        }
        return result;
    }

    @Override
    public Payment triggerPayment(String accountId, String paymentId, RequestOptions options) {
        logger.debug("triggerPayment param is :accountId-->{},paymentId-->{},options-->{}", new Object[]{accountId, paymentId, options});
        if (StringUtils.isEmpty((Object)accountId)) {
            return null;
        }
        Payment payment = null;
        try {
            PaymentMethods paymentMethods = this.accountApi.getPaymentMethodsForAccount(UUID.fromString(accountId), null, options);
            PaymentTransaction body = new PaymentTransaction();
            body.setAmount(BigDecimal.ONE);
            body.setCurrency(Currency.CNY);
            body.setTransactionType(TransactionType.AUTHORIZE);
            List NULL_PLUGIN_NAMES = null;
            Map NULL_PLUGIN_PROPERTIES = null;
            payment = paymentMethods == null || paymentMethods.size() == 0 ? this.accountApi.processPayment(UUID.fromString(accountId), body, null, NULL_PLUGIN_NAMES, NULL_PLUGIN_PROPERTIES, options) : this.accountApi.processPayment(UUID.fromString(accountId), body, ((PaymentMethod)paymentMethods.get(0)).getPaymentMethodId(), NULL_PLUGIN_NAMES, NULL_PLUGIN_PROPERTIES, options);
        }
        catch (KillBillClientException e) {
            logger.error("triggerPayment KillBillClientException", (Throwable)e);
            throw new KillbillServiceException(KillbillExceptionEnum.ERROR_PROCESS_PAYMENT.getCode(), KillbillExceptionEnum.ERROR_PROCESS_PAYMENT.getMessage());
        }
        return payment;
    }

    @Override
    public InvoicePayments getInvoicePaymentByAccount(String accountId, RequestOptions options) {
        logger.debug("getInvoicePaymentByAccount param is :accountId-->{},options-->{}", (Object)accountId, (Object)options);
        if (StringUtils.isEmpty((Object)accountId)) {
            return null;
        }
        try {
            return this.accountApi.getInvoicePayments(UUID.fromString(accountId), null, options);
        }
        catch (KillBillClientException e) {
            logger.error("getInvoicePaymentByAccount KillBillClientException", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<Invoice> getInvoices(String accountId, RequestOptions options) {
        logger.debug("getInvoices param is :accountId-->{},options-->{}", (Object)accountId, (Object)options);
        if (StringUtils.isEmpty((Object)accountId)) {
            return null;
        }
        try {
            return this.accountApi.getInvoicesForAccount(UUID.fromString(accountId), null, options);
        }
        catch (KillBillClientException e) {
            logger.error("getInvoices KillBillClientException", (Throwable)e);
            return null;
        }
    }

    void addPaymentMethod(UUID accountId, String companyCode, RequestOptions options) {
        PaymentMethodPluginDetail info = new PaymentMethodPluginDetail();
        ImmutableList EMPTY_AUDIT_LOGS = ImmutableList.of();
        List NULL_PLUGIN_NAMES = null;
        Map NULL_PLUGIN_PROPERTIES = null;
        try {
            PaymentMethods paymentMethods = this.accountApi.getPaymentMethodsForAccount(accountId, NULL_PLUGIN_PROPERTIES, options);
        }
        catch (KillBillClientException e) {
            logger.error("getPaymentMethodsForAccount KillBillClientException", (Throwable)e);
            PaymentMethods paymentMethods = new PaymentMethods();
        }
        PaymentMethod defaultPaymentMethod = new PaymentMethod(null, KillbillConstant.buildExternalPaymentName(companyCode), accountId, Boolean.valueOf(false), "__EXTERNAL_PAYMENT__", info, (List)EMPTY_AUDIT_LOGS);
        PaymentMethod aliPaymentMethod = new PaymentMethod(null, KillbillConstant.buildAliPaymentName(companyCode), accountId, Boolean.valueOf(false), "payment-alipay-plugin", info, (List)EMPTY_AUDIT_LOGS);
        try {
            this.accountApi.createPaymentMethod(accountId, defaultPaymentMethod, NULL_PLUGIN_NAMES, NULL_PLUGIN_PROPERTIES, options);
            this.accountApi.createPaymentMethod(accountId, aliPaymentMethod, NULL_PLUGIN_NAMES, NULL_PLUGIN_PROPERTIES, options);
        }
        catch (KillBillClientException e) {
            logger.error("addPaymentMethod KillBillClientException", (Throwable)e);
            throw new KillbillServiceException(KillbillExceptionEnum.ERROR_CREATE_PAYMENT_METHOD.getCode(), KillbillExceptionEnum.ERROR_CREATE_PAYMENT_METHOD.getMessage());
        }
    }
}

