/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xplat.bill.killbill.service.impl;

import com.xforceplus.xplat.bill.killbill.enums.KillbillExceptionEnum;
import com.xforceplus.xplat.bill.killbill.exception.KillbillServiceException;
import com.xforceplus.xplat.bill.killbill.service.KillbillBundleService;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.client.KillBillClientException;
import org.killbill.billing.client.RequestOptions;
import org.killbill.billing.client.api.gen.BundleApi;
import org.killbill.billing.client.model.Bundles;
import org.killbill.billing.client.model.gen.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KillbillBundleServiceImpl
implements KillbillBundleService {
    private static final Logger logger = LoggerFactory.getLogger(KillbillBundleServiceImpl.class);
    @Autowired
    BundleApi bundleApi;

    @Override
    public List<Bundle> queryBundles(Long offset, Long limit, RequestOptions options) {
        try {
            return this.bundleApi.getBundles(offset, limit, null, options);
        }
        catch (KillBillClientException e) {
            logger.error("queryBundles KillBillClientException", (Throwable)e);
            return null;
        }
    }

    @Override
    public int count(RequestOptions options) {
        try {
            Bundles bundles = this.bundleApi.getBundles(options);
            return bundles == null ? 0 : bundles.size();
        }
        catch (KillBillClientException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public void pauseBundle(String bundleId, LocalDate requestedDate, Map<String, String> pluginProperty, RequestOptions options) {
        try {
            this.bundleApi.pauseBundle(UUID.fromString(bundleId), requestedDate, pluginProperty, options);
        }
        catch (KillBillClientException e) {
            logger.error("[\u6682\u505cbundle\u5f02\u5e38] bundleId:{},e:{}", (Object)bundleId, (Object)e);
            throw new KillbillServiceException(KillbillExceptionEnum.ERROR_PAUSE_BUNDLE.getCode(), KillbillExceptionEnum.ERROR_PAUSE_BUNDLE.getMessage());
        }
    }

    @Override
    public void resumeBundle(String bundleId, LocalDate requestedDate, Map<String, String> pluginProperty, RequestOptions options) {
        try {
            this.bundleApi.resumeBundle(UUID.fromString(bundleId), requestedDate, pluginProperty, options);
        }
        catch (KillBillClientException e) {
            logger.error("[\u91cd\u542fbundle\u5f02\u5e38] bundleId:{},e:{}", (Object)bundleId, (Object)e);
            throw new KillbillServiceException(KillbillExceptionEnum.ERROR_RESUME_BUNDLE.getCode(), KillbillExceptionEnum.ERROR_RESUME_BUNDLE.getMessage());
        }
    }
}

