/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xplat.bill.killbill.service.impl;

import com.google.common.collect.ImmutableList;
import com.xforceplus.xplat.bill.killbill.enums.KillbillExceptionEnum;
import com.xforceplus.xplat.bill.killbill.exception.KillbillServiceException;
import com.xforceplus.xplat.bill.killbill.service.KillbillInvoiceService;
import com.xforceplus.xplat.bill.killbill.util.CodeUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePeriod;
import org.killbill.billing.ObjectType;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.client.KillBillClientException;
import org.killbill.billing.client.RequestOptions;
import org.killbill.billing.client.api.gen.AccountApi;
import org.killbill.billing.client.api.gen.InvoiceApi;
import org.killbill.billing.client.model.CustomFields;
import org.killbill.billing.client.model.InvoiceItems;
import org.killbill.billing.client.model.InvoicePayments;
import org.killbill.billing.client.model.Invoices;
import org.killbill.billing.client.model.gen.CustomField;
import org.killbill.billing.client.model.gen.Invoice;
import org.killbill.billing.client.model.gen.InvoiceDryRun;
import org.killbill.billing.client.model.gen.InvoiceItem;
import org.killbill.billing.entitlement.api.SubscriptionEventType;
import org.killbill.billing.invoice.api.DryRunType;
import org.killbill.billing.util.api.AuditLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class KillbillInvoiceServiceImpl
implements KillbillInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(KillbillInvoiceServiceImpl.class);
    @Autowired
    InvoiceApi invoiceApi;
    @Autowired
    AccountApi accountApi;
    @Autowired
    RequestOptions xpOptions;
    @Value(value="${killbill.dryRunAccountId}")
    private String kbAccountId;

    @Override
    public List<Invoice> query(Long offset, Long limit, RequestOptions options) {
        try {
            return this.invoiceApi.getInvoices(offset, limit, AuditLevel.NONE, options);
        }
        catch (KillBillClientException e) {
            logger.error("query KillBillClientException", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<Invoice> queryForAccount(String accountId, Long offset, Long limit, RequestOptions options) {
        try {
            return this.invoiceApi.searchInvoices(accountId, offset, limit, AuditLevel.NONE, options);
        }
        catch (KillBillClientException e) {
            logger.error("queryForAccount KillBillClientException", (Throwable)e);
            return null;
        }
    }

    @Override
    public int count(String accountId, RequestOptions options) {
        if (StringUtils.isEmpty((Object)accountId)) {
            return 0;
        }
        try {
            Invoices invoices = this.accountApi.getInvoicesForAccount(UUID.fromString(accountId), null, options);
            return invoices == null ? 0 : invoices.size();
        }
        catch (KillBillClientException e) {
            logger.error("count KillBillClientException", (Throwable)e);
            return 0;
        }
    }

    @Override
    public Invoice getInvoiceByInvoiceId(String invoiceId, RequestOptions options) {
        try {
            return this.invoiceApi.getInvoice(UUID.fromString(invoiceId), Boolean.valueOf(true), AuditLevel.NONE, options);
        }
        catch (KillBillClientException e) {
            logger.error("getInvoiceByInvoiceId KillBillClientException", (Throwable)e);
            try {
                Thread.sleep(1000L);
                return this.invoiceApi.getInvoice(UUID.fromString(invoiceId), Boolean.valueOf(true), AuditLevel.NONE, this.xpOptions);
            }
            catch (KillBillClientException e1) {
                logger.warn("[\u67e5\u8be2\u8d26\u5355\u4fe1\u606f\u5f02\u5e38] e:{}", (Throwable)e);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public InvoicePayments getPaymentsByInvoiceId(String invoiceId, RequestOptions options) {
        try {
            return this.invoiceApi.getPaymentsForInvoice(UUID.fromString(invoiceId), options);
        }
        catch (KillBillClientException e) {
            logger.error("getPaymentsByInvoiceId KillBillClientException", (Throwable)e);
            try {
                Thread.sleep(2000L);
                return this.invoiceApi.getPaymentsForInvoice(UUID.fromString(invoiceId), options);
            }
            catch (KillBillClientException e1) {
                logger.error("getPaymentsByInvoiceId KillBillClientException", (Throwable)e);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
                logger.error("getPaymentsByInvoiceId KillBillClientException", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public String createCustomFieldRemitCode(UUID invoiceId, RequestOptions options) {
        try {
            CustomFields customFields = this.invoiceApi.getInvoiceCustomFields(invoiceId, options);
            if (customFields.size() <= 0) {
                ImmutableList EMPTY_AUDIT_LOGS = ImmutableList.of();
                CustomFields newCustomFields = new CustomFields();
                newCustomFields.add((Object)new CustomField(null, invoiceId, ObjectType.INVOICE, "remit_code", CodeUtil.getRandomString(5), (List)EMPTY_AUDIT_LOGS));
                this.invoiceApi.createInvoiceCustomFields(invoiceId, newCustomFields, options);
                return ((CustomField)newCustomFields.get(0)).getValue();
            }
            return ((CustomField)customFields.get(0)).getValue();
        }
        catch (KillBillClientException e) {
            logger.error("createCustomFieldRemitCode KillBillClientException", (Throwable)e);
            return null;
        }
    }

    @Override
    public Invoice adjustmentInvoiceItem(String invoiceId, InvoiceItem item, RequestOptions options) {
        try {
            return this.invoiceApi.adjustInvoiceItem(UUID.fromString(invoiceId), item, null, null, options);
        }
        catch (KillBillClientException e) {
            if (e.getBillingException().getCode() == 4020) {
                logger.warn("\u4f20\u5165\u91d1\u989d\u5927\u4e8e\u8d26\u5355\u660e\u7ec6\u91d1\u989d\u5f02\u5e38\uff0c\u9ed8\u8ba4\u4e3a\u8d26\u5355invoiceId {}\uff0c\u8d26\u5355\u660e\u7ec6 {} \u91d1\u989d\u5df2\u8c03\u6574", (Object)invoiceId, (Object)item.getInvoiceItemId().toString());
                return null;
            }
            logger.error("adjustmentInvoiceItem KillBillClientException", (Throwable)e);
            throw new KillbillServiceException(KillbillExceptionEnum.ERROR_ADJUST_INVOICE_ITEM.getCode(), KillbillExceptionEnum.ERROR_ADJUST_INVOICE_ITEM.getMessage());
        }
    }

    @Override
    public BigDecimal dryRun(String productName, String billingPeriodStr, int times, String planCode, RequestOptions requestOptions) {
        logger.info("dryRun param is :kbAccountId--->{},productName--->{},billingPeriodStr--->{},times--->{},planCode--->{},requestOptions--->{}", new Object[]{this.kbAccountId, productName, billingPeriodStr, times, planCode, requestOptions});
        DryRunType dryRunType = DryRunType.SUBSCRIPTION_ACTION;
        SubscriptionEventType dryRunAction = SubscriptionEventType.START_BILLING;
        PhaseType phaseType = null;
        ProductCategory productCategory = ProductCategory.BASE;
        BillingPeriod billingPeriod = KillbillInvoiceServiceImpl.getBillingPeriod(billingPeriodStr);
        String priceListName = planCode + "_PriceList";
        UUID subscriptionId = null;
        UUID bundleId = null;
        LocalDate effectiveDate = null;
        BillingActionPolicy billingPolicy = null;
        List priceOverrides = null;
        InvoiceDryRun dryRunArg = new InvoiceDryRun(dryRunType, dryRunAction, phaseType, productName, productCategory, billingPeriod, priceListName, subscriptionId, bundleId, effectiveDate, billingPolicy, priceOverrides);
        LocalDate targetDate = KillbillInvoiceServiceImpl.getTargetDate(times, billingPeriod);
        logger.info(" dryrun targetDate is :{}", (Object)targetDate);
        try {
            Invoice dryRunInvoice = this.invoiceApi.generateDryRunInvoice(dryRunArg, UUID.fromString(this.kbAccountId), targetDate, requestOptions);
            if (null != dryRunInvoice) {
                logger.info("dryRunInvoice result is :{}", (Object)dryRunInvoice.getAmount());
                return dryRunInvoice.getAmount();
            }
        }
        catch (KillBillClientException e) {
            logger.error("generateDryRunInvoice exception", (Throwable)e);
            throw new KillbillServiceException(KillbillExceptionEnum.ERROR_DRY_RUN.getCode(), KillbillExceptionEnum.ERROR_DRY_RUN.getMessage());
        }
        return new BigDecimal("-1");
    }

    @Override
    public String createExternalCharge(String kbAccountId, BigDecimal chargeAmount, String orderRecodeId, RequestOptions requestOptions) {
        logger.info("createExternalCharge param is :{},{},{},{}", new Object[]{kbAccountId, chargeAmount, orderRecodeId, requestOptions});
        UUID accountId = UUID.fromString(kbAccountId);
        InvoiceItem externalCharge = new InvoiceItem();
        externalCharge.setAccountId(accountId);
        externalCharge.setAmount(chargeAmount);
        externalCharge.setDescription(orderRecodeId);
        InvoiceItems externalCharges = new InvoiceItems();
        externalCharges.add((Object)externalCharge);
        LocalDate requestedDate = LocalDate.now();
        Boolean payInvoice = false;
        Map pluginProperty = null;
        Boolean autoCommit = true;
        try {
            InvoiceItems createdExternalCharges = this.invoiceApi.createExternalCharges(accountId, externalCharges, requestedDate, autoCommit, pluginProperty, requestOptions);
            if (createdExternalCharges.isEmpty()) {
                throw new KillbillServiceException("EXTERNAL_CHARGE_FAIL", "\u83b7\u53d6\u4e0d\u5230\u5916\u90e8\u652f\u4ed8\u8d26\u5355");
            }
            return ((InvoiceItem)createdExternalCharges.get(0)).getInvoiceId().toString();
        }
        catch (KillBillClientException e) {
            logger.error("createExternalCharge KillBillClientException : {}", (Throwable)e);
            throw new KillbillServiceException(KillbillExceptionEnum.ERROR_CREATE_EXTERNAL_CHARGE.getCode(), KillbillExceptionEnum.ERROR_CREATE_EXTERNAL_CHARGE.getMessage());
        }
    }

    @Override
    public void voidInvoice(String invoiceId, RequestOptions options) {
        try {
            this.invoiceApi.voidInvoice(UUID.fromString(invoiceId), options);
        }
        catch (KillBillClientException e) {
            logger.error("voidInvoice KillBillClientException : {}", (Throwable)e);
            throw new KillbillServiceException(KillbillExceptionEnum.ERROR_VOID_INVOICE.getCode(), KillbillExceptionEnum.ERROR_VOID_INVOICE.getMessage());
        }
    }

    public static LocalDate getTargetDate(int quantity, BillingPeriod billingPeriod) {
        LocalDate localDate = LocalDate.now();
        for (int i = 0; i < quantity; ++i) {
            localDate = localDate.plus((ReadablePeriod)billingPeriod.getPeriod());
        }
        return localDate.minusDays(1);
    }

    public static void main(String[] args) {
        Date date = KillbillInvoiceServiceImpl.getTargetDate(2, BillingPeriod.DAILY).toDate();
        System.out.println(date.getTime());
    }

    public static BillingPeriod getBillingPeriod(String billingPeriod) {
        switch (billingPeriod) {
            case "ANNUAL": {
                return BillingPeriod.ANNUAL;
            }
            case "BIANNUAL": {
                return BillingPeriod.BIANNUAL;
            }
            case "BIENNIAL": {
                return BillingPeriod.BIENNIAL;
            }
            case "BIWEEKLY": {
                return BillingPeriod.BIWEEKLY;
            }
            case "BIMESTRIAL": {
                return BillingPeriod.BIMESTRIAL;
            }
            case "DAILY": {
                return BillingPeriod.DAILY;
            }
            case "MONTHLY": {
                return BillingPeriod.MONTHLY;
            }
            case "NINETY_DAYS": {
                return BillingPeriod.NINETY_DAYS;
            }
            case "NO_BILLING_PERIOD": {
                return BillingPeriod.NO_BILLING_PERIOD;
            }
            case "QUARTERLY": {
                return BillingPeriod.QUARTERLY;
            }
            case "SIXTY_DAYS": {
                return BillingPeriod.SIXTY_DAYS;
            }
            case "THIRTY_DAYS": {
                return BillingPeriod.THIRTY_DAYS;
            }
            case "TRIANNUAL": {
                return BillingPeriod.TRIANNUAL;
            }
            case "WEEKLY": {
                return BillingPeriod.WEEKLY;
            }
        }
        return BillingPeriod.MONTHLY;
    }
}

