/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xplat.bill.killbill.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.xplat.bill.killbill.constant.KillbillConstant;
import com.xforceplus.xplat.bill.killbill.enums.KillbillExceptionEnum;
import com.xforceplus.xplat.bill.killbill.exception.KillbillServiceException;
import com.xforceplus.xplat.bill.killbill.service.KillbillPaymentService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.client.KillBillClientException;
import org.killbill.billing.client.RequestOptions;
import org.killbill.billing.client.api.gen.AccountApi;
import org.killbill.billing.client.api.gen.InvoiceApi;
import org.killbill.billing.client.api.gen.PaymentApi;
import org.killbill.billing.client.api.gen.PaymentGatewayApi;
import org.killbill.billing.client.api.gen.PaymentMethodApi;
import org.killbill.billing.client.model.PaymentMethods;
import org.killbill.billing.client.model.Payments;
import org.killbill.billing.client.model.gen.HostedPaymentPageFields;
import org.killbill.billing.client.model.gen.HostedPaymentPageFormDescriptor;
import org.killbill.billing.client.model.gen.Invoice;
import org.killbill.billing.client.model.gen.InvoicePayment;
import org.killbill.billing.client.model.gen.Payment;
import org.killbill.billing.client.model.gen.PaymentMethod;
import org.killbill.billing.client.model.gen.PluginProperty;
import org.killbill.billing.util.api.AuditLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class KillbillPaymentServiceImpl
implements KillbillPaymentService {
    private static final Logger logger = LoggerFactory.getLogger(KillbillPaymentServiceImpl.class);
    @Autowired
    PaymentApi paymentApi;
    @Autowired
    AccountApi accountApi;
    @Autowired
    PaymentGatewayApi paymentGatewayApi;
    @Autowired
    PaymentMethodApi paymentMethodApi;
    @Autowired
    InvoiceApi invoiceApi;
    public static final String PROPERTY_CREATE_PENDING_PAYMENT = "createPendingPayment";
    public static final String PROPERTY_PAYMENT_METHOD_ID = "paymentMethodId";
    public static final String PROPERTY_PAYMENT_EXTERNAL_KEY = "paymentExternalKey";
    public static final String PROPERTY_AMOUNT = "amount";
    public static final String PROPERTY_CURRENCY = "currency";
    public static final String PROPERTY_INVOICE_ID = "invoiceId";

    @Override
    public List<Payment> query(Long offset, Long limit, RequestOptions options) {
        try {
            return this.paymentApi.getPayments(offset, limit, null, Boolean.valueOf(false), Boolean.valueOf(false), null, AuditLevel.NONE, options);
        }
        catch (KillBillClientException e) {
            logger.error("KillBillClientException {}", (Throwable)e);
            return null;
        }
    }

    @Override
    public int count(RequestOptions options) {
        try {
            Payments payments = this.paymentApi.getPayments(null, null, options);
            return payments == null ? 0 : payments.size();
        }
        catch (KillBillClientException e) {
            logger.error("KillBillClientException {}", (Throwable)e);
            return 0;
        }
    }

    @Override
    public Payment getPaymentByPaymentId(String paymentId, RequestOptions options) {
        if (StringUtils.isEmpty((Object)paymentId)) {
            return null;
        }
        try {
            return this.paymentApi.getPayment(UUID.fromString(paymentId), null, options);
        }
        catch (KillBillClientException e) {
            logger.error("KillBillClientException {}", (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<String, Object> triggerAliPayment(String accountId, String invoiceId, List<PluginProperty> plusProperties, RequestOptions options) {
        logger.debug("triggerAliPayment param is :accountId-->{},invoiceId-->{},plusProperties-->{}", new Object[]{accountId, invoiceId, plusProperties});
        HashMap result = Maps.newHashMap();
        result.put("result", null);
        if (StringUtils.isEmpty((Object)accountId)) {
            result.put("msg", "\u516c\u53f8\u8d26\u53f7\u4e0d\u5b58\u5728");
            return result;
        }
        if (StringUtils.isEmpty((Object)invoiceId)) {
            result.put("msg", "\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        try {
            PaymentMethods paymentMethods = this.accountApi.getPaymentMethodsForAccount(UUID.fromString(accountId), null, options);
            String paymentMethodId = KillbillConstant.getPaymentMenthodId(paymentMethods, "payment-alipay-plugin");
            if (paymentMethodId == null) {
                logger.error("{}\u8be5\u516c\u53f8\u6ca1\u6709\u914d\u7f6e\u652f\u4ed8\u5b9d\u652f\u4ed8\u65b9\u5f0f", (Object)accountId);
                result.put("msg", "\u8be5\u516c\u53f8\u6ca1\u6709\u914d\u7f6e\u652f\u4ed8\u5b9d\u652f\u4ed8\u65b9\u5f0f");
                return result;
            }
            Invoice invoice = this.invoiceApi.getInvoice(UUID.fromString(invoiceId), options);
            PluginProperty pluginProperty1 = new PluginProperty(PROPERTY_AMOUNT, invoice.getAmount().toString(), Boolean.valueOf(true));
            PluginProperty pluginProperty2 = new PluginProperty(PROPERTY_CREATE_PENDING_PAYMENT, "true", Boolean.valueOf(true));
            PluginProperty pluginProperty3 = new PluginProperty(PROPERTY_CURRENCY, Currency.CNY.name(), Boolean.valueOf(true));
            PluginProperty pluginProperty4 = new PluginProperty(PROPERTY_PAYMENT_METHOD_ID, paymentMethodId, Boolean.valueOf(true));
            PluginProperty pluginProperty5 = new PluginProperty(PROPERTY_INVOICE_ID, invoiceId, Boolean.valueOf(true));
            ArrayList pluginProperties = Lists.newArrayList();
            pluginProperties.add(pluginProperty1);
            pluginProperties.add(pluginProperty2);
            pluginProperties.add(pluginProperty3);
            pluginProperties.add(pluginProperty4);
            pluginProperties.add(pluginProperty5);
            if (plusProperties != null) {
                pluginProperties.addAll(plusProperties);
            }
            HostedPaymentPageFields body = new HostedPaymentPageFields((List)pluginProperties);
            List NULL_PLUGIN_NAMES = null;
            Map NULL_PLUGIN_PROPERTIES = null;
            HostedPaymentPageFormDescriptor form = this.paymentGatewayApi.buildFormDescriptor(UUID.fromString(accountId), body, UUID.fromString(paymentMethodId), NULL_PLUGIN_NAMES, NULL_PLUGIN_PROPERTIES, options);
            result.put("result", form);
            if (form == null) {
                logger.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u63d2\u4ef6\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                result.put("msg", "\u8c03\u7528\u652f\u4ed8\u5b9d\u63d2\u4ef6\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            }
        }
        catch (KillBillClientException e) {
            logger.error("KillBillClientException {}", (Throwable)e);
            throw new KillbillServiceException(KillbillExceptionEnum.ERROR_TRIGGER_ALIPAY.getCode(), KillbillExceptionEnum.ERROR_TRIGGER_ALIPAY.getMessage());
        }
        return result;
    }

    @Override
    public Map<String, Object> triggerExternalPayment(String accountId, String invoiceId, RequestOptions options) {
        HashMap result = Maps.newHashMap();
        if (StringUtils.isEmpty((Object)accountId)) {
            result.put("msg", "\u516c\u53f8\u8d26\u53f7\u4e0d\u5b58\u5728");
            return result;
        }
        if (StringUtils.isEmpty((Object)invoiceId)) {
            result.put("msg", "\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        try {
            Invoice invoice = this.invoiceApi.getInvoice(UUID.fromString(invoiceId), options);
            InvoicePayment invoicePayment = new InvoicePayment();
            invoicePayment.setAccountId(UUID.fromString(accountId));
            invoicePayment.setTargetInvoiceId(UUID.fromString(invoiceId));
            invoicePayment.setPurchasedAmount(invoice.getAmount());
            invoicePayment.setCurrency(Currency.CNY);
            Boolean externalPayment = true;
            Map pluginProperty = null;
            InvoicePayment instantPayment = this.invoiceApi.createInstantPayment(UUID.fromString(invoiceId), invoicePayment, externalPayment, pluginProperty, options);
            result.put("result", instantPayment);
        }
        catch (KillBillClientException e) {
            logger.error("KillBillClientException {}", (Throwable)e);
            throw new KillbillServiceException(KillbillExceptionEnum.ERROR_TRIGGER_EXTERNAL_PAYMENT.getCode(), KillbillExceptionEnum.ERROR_TRIGGER_EXTERNAL_PAYMENT.getMessage());
        }
        return result;
    }

    @Override
    public int notification(String pluginName, String body, RequestOptions options) {
        int status = 1;
        try {
            this.paymentGatewayApi.processNotification(pluginName, body, null, (Map)Maps.newHashMap(), options);
        }
        catch (KillBillClientException e) {
            logger.error("KillBillClientException {}", (Throwable)e);
            status = 0;
        }
        return status;
    }

    @Override
    public String getPaymentMethod(UUID paymentMethodId, RequestOptions options) {
        String paymentMethodName = "";
        try {
            PaymentMethod paymentMethod = this.paymentMethodApi.getPaymentMethod(paymentMethodId, null, options);
            if (paymentMethod != null) {
                if ("payment-alipay-plugin".equals(paymentMethod.getPluginName())) {
                    paymentMethodName = "ALIPAY";
                } else if ("__EXTERNAL_PAYMENT__".equals(paymentMethod.getPluginName())) {
                    paymentMethodName = "OFFLINE";
                }
            }
        }
        catch (KillBillClientException e) {
            logger.error("KillBillClientException {}", (Throwable)e);
        }
        return paymentMethodName;
    }
}

