/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xplat.bill.killbill.service.impl;

import com.google.common.collect.ImmutableMap;
import com.xforceplus.xplat.bill.killbill.enums.KillbillExceptionEnum;
import com.xforceplus.xplat.bill.killbill.exception.KillbillServiceException;
import com.xforceplus.xplat.bill.killbill.service.KillbillSubscriptionService;
import java.util.Map;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.client.KillBillClientException;
import org.killbill.billing.client.RequestOptions;
import org.killbill.billing.client.api.gen.SubscriptionApi;
import org.killbill.billing.client.model.gen.Subscription;
import org.killbill.billing.entitlement.api.Entitlement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class KillbillSubscriptionServiceImpl
implements KillbillSubscriptionService {
    private static final Logger logger = LoggerFactory.getLogger(KillbillSubscriptionServiceImpl.class);
    @Autowired
    SubscriptionApi subscriptionApi;

    @Override
    public Subscription createSubscription(Subscription subscriptionIn, RequestOptions options) {
        LocalDate entitlementDate = null;
        LocalDate billingDate = null;
        Boolean renameKeyIfExistsAndUnused = true;
        Boolean migrated = null;
        Boolean callCompletion = true;
        long DEFAULT_WAIT_COMPLETION_TIMEOUT_SEC = 10L;
        ImmutableMap<String, String> NULL_PLUGIN_PROPERTIES = null;
        return this.createSubscription(subscriptionIn, entitlementDate, billingDate, renameKeyIfExistsAndUnused, migrated, callCompletion, DEFAULT_WAIT_COMPLETION_TIMEOUT_SEC, NULL_PLUGIN_PROPERTIES, options);
    }

    @Override
    public Subscription getSubscription(String subscriptionId, RequestOptions options) {
        if (StringUtils.isEmpty((Object)subscriptionId)) {
            return null;
        }
        try {
            return this.subscriptionApi.getSubscription(UUID.fromString(subscriptionId), options);
        }
        catch (KillBillClientException e) {
            logger.error("getSubscription KillBillClientException, \u91cd\u8bd5\u4e00\u6b21", (Throwable)e);
            try {
                Thread.sleep(1000L);
                return this.subscriptionApi.getSubscription(UUID.fromString(subscriptionId), options);
            }
            catch (KillBillClientException e1) {
                throw new KillbillServiceException(KillbillExceptionEnum.ERROR_GET_SUBSCRIPTION.getCode(), KillbillExceptionEnum.ERROR_GET_SUBSCRIPTION.getMessage());
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
                throw new KillbillServiceException(KillbillExceptionEnum.ERROR_GET_SUBSCRIPTION.getCode(), KillbillExceptionEnum.ERROR_GET_SUBSCRIPTION.getMessage());
            }
        }
        catch (Exception e) {
            logger.error("getSubscription UUID.fromString fail: " + subscriptionId);
            throw new KillbillServiceException(KillbillExceptionEnum.ERROR_GET_SUBSCRIPTION.getCode(), KillbillExceptionEnum.ERROR_GET_SUBSCRIPTION.getMessage());
        }
    }

    @Override
    public Subscription createSubscription(Subscription subscriptionIn, LocalDate entitlementDate, LocalDate billingDate, Boolean renameKeyIfExistsAndUnused, Boolean migrated, Boolean callCompletion, long timeout, ImmutableMap<String, String> properties, RequestOptions options) {
        try {
            return this.subscriptionApi.createSubscription(subscriptionIn, entitlementDate, billingDate, renameKeyIfExistsAndUnused, migrated, callCompletion, Long.valueOf(timeout), properties, options);
        }
        catch (KillBillClientException e) {
            logger.error("createSubscription KillBillClientException \u5931\u8d25\uff0c\u91cd\u8bd5\u4e00\u6b21", (Throwable)e);
            try {
                Thread.sleep(1000L);
                return this.subscriptionApi.createSubscription(subscriptionIn, entitlementDate, billingDate, renameKeyIfExistsAndUnused, migrated, callCompletion, Long.valueOf(timeout), properties, options);
            }
            catch (KillBillClientException e1) {
                throw new KillbillServiceException(KillbillExceptionEnum.ERROR_CREATE_SUBSCRIPTION.getCode(), KillbillExceptionEnum.ERROR_CREATE_SUBSCRIPTION.getMessage());
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
                throw new KillbillServiceException(KillbillExceptionEnum.ERROR_CREATE_SUBSCRIPTION.getCode(), KillbillExceptionEnum.ERROR_CREATE_SUBSCRIPTION.getMessage());
            }
        }
    }

    @Override
    public void cancelSubscriptionPlan(String subscriptionId, LocalDate requestedDate, Entitlement.EntitlementActionPolicy entitlementPolicy, BillingActionPolicy billingPolicy, Map<String, String> pluginProperty, RequestOptions options) {
        try {
            this.subscriptionApi.cancelSubscriptionPlan(UUID.fromString(subscriptionId), requestedDate, entitlementPolicy, billingPolicy, pluginProperty, options);
        }
        catch (KillBillClientException e) {
            logger.error("[cancelSubscriptionPlan \u53d6\u6d88\u8ba2\u9605\u6267\u884c\u5f02\u5e38] e:{}", (Throwable)e);
            throw new KillbillServiceException(KillbillExceptionEnum.ERROR_CANCEL_SUBSCRIPTION_PLAN.getCode(), KillbillExceptionEnum.ERROR_CANCEL_SUBSCRIPTION_PLAN.getMessage());
        }
        catch (Exception e) {
            logger.error("[cancelSubscriptionPlan \u53d6\u6d88\u8ba2\u9605\u6267\u884c\u5f02\u5e38] e:{}", (Throwable)e);
            throw new KillbillServiceException(KillbillExceptionEnum.ERROR_CANCEL_SUBSCRIPTION_PLAN.getCode(), KillbillExceptionEnum.ERROR_CANCEL_SUBSCRIPTION_PLAN.getMessage());
        }
    }
}

