/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xplat.bill.killbill.service.impl;

import com.xforceplus.xplat.bill.killbill.enums.KillbillExceptionEnum;
import com.xforceplus.xplat.bill.killbill.exception.KillbillServiceException;
import com.xforceplus.xplat.bill.killbill.service.KillbillTenantService;
import org.killbill.billing.client.KillBillClientException;
import org.killbill.billing.client.RequestOptions;
import org.killbill.billing.client.api.gen.TenantApi;
import org.killbill.billing.client.model.gen.Tenant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KillbillTenantServiceImpl
implements KillbillTenantService {
    private static Logger logger = LoggerFactory.getLogger(KillbillTenantServiceImpl.class);
    @Autowired
    TenantApi tenantApi;

    @Override
    public Tenant createTenant(String apiKey, String apiSecret, RequestOptions options) {
        return this.createTenant(null, apiKey, apiSecret, options);
    }

    @Override
    public Tenant createTenant(String externalKey, String apiKey, String apiSecret, RequestOptions options) {
        try {
            Tenant tenant = this.tenantApi.getTenantByApiKey(apiKey, options);
            if (tenant != null) {
                logger.warn("createTenant \u79df\u6237\u5df2\u5b58\u5728");
                throw new KillbillServiceException(KillbillExceptionEnum.ERROR_CREATE_TENANT.getCode(), KillbillExceptionEnum.ERROR_CREATE_TENANT.getMessage());
            }
            Tenant body = new Tenant(null, externalKey, apiKey, apiSecret, null);
            return this.tenantApi.createTenant(body, options);
        }
        catch (KillBillClientException e) {
            logger.error("createTenant KillBillClientException", (Throwable)e);
            throw new KillbillServiceException(KillbillExceptionEnum.ERROR_CREATE_TENANT.getCode(), KillbillExceptionEnum.ERROR_CREATE_TENANT.getMessage());
        }
    }
}

