/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xplat.bill.killbill.service.impl;

import com.google.common.collect.Lists;
import com.xforceplus.xplat.bill.killbill.enums.KillbillExceptionEnum;
import com.xforceplus.xplat.bill.killbill.exception.KillbillServiceException;
import com.xforceplus.xplat.bill.killbill.service.KillbillUsageService;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.client.KillBillClientException;
import org.killbill.billing.client.RequestOptions;
import org.killbill.billing.client.api.gen.UsageApi;
import org.killbill.billing.client.model.gen.SubscriptionUsageRecord;
import org.killbill.billing.client.model.gen.UnitUsageRecord;
import org.killbill.billing.client.model.gen.UsageRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KillbillUsageServiceImpl
implements KillbillUsageService {
    private static Logger logger = LoggerFactory.getLogger(KillbillUsageServiceImpl.class);
    @Autowired
    UsageApi usageApi;

    @Override
    public void recordUsage(String subscriptionId, String unitType, Long amount, Date recordDate, RequestOptions options) {
        SubscriptionUsageRecord body = new SubscriptionUsageRecord();
        body.setSubscriptionId(UUID.fromString(subscriptionId));
        UsageRecord usageRecord = new UsageRecord();
        usageRecord.setAmount(amount);
        usageRecord.setRecordDate(LocalDate.fromDateFields((Date)recordDate));
        UnitUsageRecord unitUsageRecord = new UnitUsageRecord();
        unitUsageRecord.setUnitType(unitType);
        unitUsageRecord.setUsageRecords((List)Lists.newArrayList((Object[])new UsageRecord[]{usageRecord}));
        body.setUnitUsageRecords((List)Lists.newArrayList((Object[])new UnitUsageRecord[]{unitUsageRecord}));
        try {
            this.usageApi.recordUsage(body, options);
        }
        catch (KillBillClientException e) {
            logger.error("recordUsage KillBillClientException", (Throwable)e);
            throw new KillbillServiceException(KillbillExceptionEnum.ERROR_RECORD_USAGE.getCode(), KillbillExceptionEnum.ERROR_RECORD_USAGE.getMessage());
        }
    }
}

