package com.xforceplus.xplat.epcp.sdk.infrastructure.http;

import com.xforceplus.xplat.epcp.sdk.base.BaseComponent;
import com.xforceplus.xplat.epcp.sdk.base.trait.PreInitAware;
import com.xforceplus.xplat.epcp.sdk.base.trait.Refreshable;
import org.springframework.web.reactive.function.client.WebClient;

/**
 * Http Component
 * current bind with okHttp
 * support
 */
public interface HttpComponent extends BaseComponent, Refreshable, PreInitAware {

    default String kind() {
        return "Http";
    }

    /**
     * can only effect before client created
     * @param httpInterceptor
     */
    void addInterceptor(HttpInterceptor httpInterceptor);

    /**
     * create service
     * @param service
     * @param <T>
     * @return
     */
    <T> T create(Class<T> service);

    <T> T create(String baseUrl, Class<T> service);

    WebClient getClient();

}
